/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.addressing.helpers.tests;

import junit.framework.TestCase;

import org.jboss.soa.esb.addressing.eprs.EmailEpr;

/**
 * Unit tests for the EPR class.
 * 
 * @author Mark Little
 */

public class EmailUnitTest extends TestCase
{

	public void testConstructor ()
	{
		try
		{
			new EmailEpr(EmailEpr.SMTP_PROTOCOL, "myhost", "25", "foo", "bar");
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testSetGet ()
	{
		try
		{
			EmailEpr em = new EmailEpr(EmailEpr.SMTP_PROTOCOL, "myhost", "25", "foo", "bar");
			
			assertEquals(em.getHost(), "myhost");
			assertEquals(em.getProtocol(), EmailEpr.SMTP_PROTOCOL);
			assertEquals(em.getPort(), 25);
			assertEquals(em.getUserName(), "foo");
			assertEquals(em.getPassword(), "bar");
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}

}
