/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.message.format.tests;

import java.net.URI;

import junit.framework.TestCase;

import org.jboss.internal.soa.esb.message.format.xml.MessageImpl;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.message.format.MessagePlugin;
import org.jboss.soa.esb.message.format.MessageType;

/**
 * Unit tests for the Class class.
 * 
 * @author Mark Little
 */

public class MessageFactoryUnitTest extends TestCase
{
	public void testDefaultMessage ()
	{
		Message msg = MessageFactory.getInstance().getMessage();
		
		assertEquals((msg != null), true);
	}
	
	public void testOverrideDefaultMessage ()
	{
	    ModulePropertyManager.getPropertyManager(ModulePropertyManager.CORE_MODULE).setProperty(MessageType.DEFAULT_URI, MessageType.XML_URI);
	    
		Message msg = MessageFactory.getInstance().getMessage();
		
		assertEquals((msg != null), true);
		
		assertEquals(msg instanceof MessageImpl, true);
		
		ModulePropertyManager.getPropertyManager(ModulePropertyManager.CORE_MODULE).setProperty(MessageType.DEFAULT_URI, MessageType.SERIALIZED_URI);
	}
	
	public void testURIMessage ()
	{
		Message msg1 = MessageFactory.getInstance().getMessage(MessageType.DEFAULT_TYPE);
		Message msg2 = MessageFactory.getInstance().getMessage();
		
		assertEquals(msg1.getType().equals(msg2.getType()), true);
		
		Message msg3 = MessageFactory.getInstance().getMessage(MessageType.JAVA_SERIALIZED);
		
		assertEquals(msg1.getType().equals(msg3.getType()), false);
	}
	
	public void testInvalidURIMessage ()
	{
		try
		{
			Message msg = MessageFactory.getInstance().getMessage(new URI("urn:foo"));
			
			assertEquals((msg == null), true);
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testNullURIMessage ()
	{
		try
		{
			@SuppressWarnings("unused")
			Message msg = MessageFactory.getInstance().getMessage(null);
			
			fail();
		}
		catch (IllegalArgumentException ex)
		{
			// success
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testNullURIConvertMessage ()
	{
		try
		{
			@SuppressWarnings("unused")
			Message msg = MessageFactory.getInstance().getMessage(null, null);
			
			fail();
		}
		catch (IllegalArgumentException ex)
		{
			// success
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testPlugin ()
	{
		System.setProperty(MessagePlugin.MESSAGE_PLUGIN+"1", ExampleMessagePlugin.class.getName());
		
		MessageFactory.getInstance().reset();
		
		try
		{
			URI uri = new URI(ExampleMessagePlugin.URN);
			Message msg = MessageFactory.getInstance().getMessage(uri);

			assertEquals(msg.getType().equals(uri), true);
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
}
