/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.notification;

import static org.junit.Assert.assertEquals;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;

import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.naming.NamingException;

import junit.framework.JUnit4TestAdapter;

import org.jboss.internal.soa.esb.rosetta.pooling.ConnectionException;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPool;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockejb.jms.TextMessageImpl;

/**
 * 
 * @author <a href="daniel.bevenius@redpill.se">Daniel Bevenius</a>				
 *
 */
public class NotifyJMSUnitTest
{
	private final String messageID = "1234-junittest";
	private MockNotifyJMS notifyJMS;
	private org.jboss.soa.esb.message.Message message;
	
	@Test
	public void sendNotification() throws ConfigurationException, NotificationException, JMSException, URISyntaxException
	{
		notifyJMS.sendNotification( message );
		
		assertEquals ( notifyJMS.getMessage().getJMSCorrelationID(), messageID );
	}
	
	@Test
	@Ignore
	public void addMessageProperties() throws ConfigurationException, NotificationException, JMSException, URISyntaxException
	{
		//TODO: add test for JIRA http://jira.jboss.com/jira/browse/JBESB-701. DanielB 2007-08-01
		
		//add message properties ...
		notifyJMS.sendNotification( message );
		assertEquals ( notifyJMS.getMessage().getJMSCorrelationID(), messageID );
	}
	
	@Before
	public void setup() throws ConfigurationException, URISyntaxException
	{
		notifyJMS = new MockNotifyJMS( new ConfigTree("") );
		message = MessageFactory.getInstance().getMessage();
		message.getHeader().getCall().setMessageID( new URI( messageID ) ) ;
	}
		

	private static class MockNotifyJMS extends NotifyJMS
	{
		private Message message;
		
		protected MockNotifyJMS(ConfigTree p_oP) throws ConfigurationException
		{
			super( p_oP );
			sessions = new Session[1];
			sessions[0] = new MockJMSSession();
		}

		@Override
		protected void send( Message jmsMessage, MessageProducer msgProducer ) throws JMSException { }
		
		@Override
		protected void sendToAll (final Message jmsMessage) throws JMSException
		{
			message = jmsMessage;
		}

		public Message getMessage()
		{
			return message;
		}

		@Override
		protected MessageProducer createProducer( JmsConnectionPool pool,
				String sAtt, Session session, Properties environment )
				throws NamingException, JMSException, ConnectionException
		{
			return null;
		}

		@Override
		protected Session getSession( JmsConnectionPool pool )
				throws NamingException, JMSException, ConnectionException
		{
			return null;
		}
		
	}
	
	private static class MockJMSSession implements Session
	{
		/**
		 * Creates a mockejb.jms.TextMessageImpl
		 */
		public TextMessage createTextMessage( String text ) throws JMSException 
		{ 
			return new TextMessageImpl ( text ); 
		}
		public void close() throws JMSException { }
		public void commit() throws JMSException { }
		public QueueBrowser createBrowser( Queue arg0 ) throws JMSException { return null; }
		public QueueBrowser createBrowser( Queue arg0, String arg1 ) throws JMSException { return null; }
		public BytesMessage createBytesMessage() throws JMSException { return null; }
		public MessageConsumer createConsumer( Destination arg0 ) throws JMSException { return null; }
		public MessageConsumer createConsumer( Destination arg0, String arg1 ) throws JMSException { return null; }
		public MessageConsumer createConsumer( Destination arg0, String arg1, boolean arg2 ) throws JMSException { return null; }
		public TopicSubscriber createDurableSubscriber( Topic arg0, String arg1 ) throws JMSException { return null; }
		public TopicSubscriber createDurableSubscriber( Topic arg0, String arg1, String arg2, boolean arg3 ) throws JMSException { return null; }
		public MapMessage createMapMessage() throws JMSException { return null; }
		public Message createMessage() throws JMSException { return null; }
		public ObjectMessage createObjectMessage() throws JMSException { return null; }
		public ObjectMessage createObjectMessage( Serializable arg0 ) throws JMSException { return null; }
		public MessageProducer createProducer( Destination arg0 ) throws JMSException { return null; }
		public Queue createQueue( String arg0 ) throws JMSException { return null; }
		public StreamMessage createStreamMessage() throws JMSException { return null; }
		public TemporaryQueue createTemporaryQueue() throws JMSException { return null; }
		public TemporaryTopic createTemporaryTopic() throws JMSException { return null; }
		public TextMessage createTextMessage() throws JMSException { return null; }
		public Topic createTopic( String arg0 ) throws JMSException { return null; }
		public int getAcknowledgeMode() throws JMSException { return 0; }
		public MessageListener getMessageListener() throws JMSException { return null; }
		public boolean getTransacted() throws JMSException { return false; }
		public void recover() throws JMSException { 		}
		public void rollback() throws JMSException { 		}
		public void run() { 		}
		public void setMessageListener( MessageListener arg0 ) throws JMSException { }
		public void unsubscribe( String arg0 ) throws JMSException { 		}
	}
	
	
	/*
	 * Just here to help Ant to find annotated test.
	 */
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter( NotifyJMSUnitTest.class );
	}	
}
