package view {
	
	import model.common.Property;
	
	import mx.controls.dataGridClasses.DataGridItemRenderer;

	/**
	 * Renderer for displaying properties in a datagrid.
	 */
	public class PropertyItemRenderer extends DataGridItemRenderer {
		
		/**
		 * Change the text color for properties that have nested content.
		 */
		override public function validateProperties():void {
	        super.validateProperties();
	        
	        if (this.data != null) {
				var property:Property = this.data as Property;
				if (property.hasNested) {
					this.setStyle("color", 0x0000FF);
				}
	        }
		}
	}
}