package model.common {
	
	/**
	 * Utilities for XML data handling.
	 */
	public class XmlUtils {
		
		/**
		 * Converts an XMLList for an attribute into a boolean value.
		 */
		public static function asBoolean(list:XMLList, fallback:Boolean):Boolean {
			if ((list == null) || (list.length() == 0)) {
				return fallback;
			}
			var value:String = list[0].toString();
			if (value == "false") {
				return false;
			}
			return true;
		}
	}
}