/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.monitoring;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

/**
 * StatisticsData is a serializable collection of StatisticsBeans.   The 
 * StatisticsData is object is the sole object that is passed in a command 
 * message from the DataCollector to the DataFiler.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 * @since Version 4.2
 */
public class StatisticsData implements Serializable {
	private static final long serialVersionUID = -2081662961582149106L;
	private static final Logger logger = Logger.getLogger(StatisticsData.class);
	private List<StatisticsBean> list;
	
	/**
	 * Constructor which creates the list of StatisticsBeans.
	 */
	public StatisticsData() {
		list = new ArrayList<StatisticsBean>();
	}
	
	/**
	 * List getter.
	 * @return list
	 */
	public List getList() {
		return list;
	}
		
	/**
	 * Method for printing all of the StatisticBean information.
	 */
	public void print() {
		for (int i = 0; i < list.size(); i++) {
			StatisticsBean sb = list.get(i);
			logger.debug(sb.toString());
		}
	}
}
