package org.jboss.soa.esb.monitoring.pojo;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

/**
 * POJO for storage of metadata concerning a JMX operation.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 * @since Version 4.2
 */
public class JMXOperation  implements java.io.Serializable {

	private static final long serialVersionUID = 1295239741130189196L;
	private Long id;
	private String objectname;
	private String servername;
	private String operation;
	private String description;
	private String returntype;
	private Boolean activeflag;
	
    /**
     * Constructor.
     */
    public JMXOperation() {
    }

    /**
     * Constructor.
     * @param objectname object name
     * @param attribute attribute name
     */
    public JMXOperation(String objectname, String servername, String operation, String description,
    		String returntype, Boolean activeflag) {
       this.objectname = objectname;
       this.operation = operation;
       this.description = description;
       this.returntype = returntype;
       this.servername = servername;
       this.activeflag = activeflag;
    }
   
    /**
     * Id getter.
     * @return id
     */
    public Long getId() {
        return this.id;
    }
    
    /**
     * Id mutator.
     * @param id id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * Object name getter.
     * @return object name
     */
    public String getObjectname() {
        return this.objectname;
    }
    
    /**
     * Object name mutator.
     * @param objectname object name
     */
    public void setObjectname(String objectname) {
        this.objectname = objectname;
    }
    
    /**
     * Server name getter.
     * @return object name
     */
    public String getServername() {
        return this.servername;
    }
    
    /**
     * Server name mutator.
     * @param objectname object name
     */
    public void setServername(String servername) {
        this.servername = servername;
    }

    /**
     * Operation name getter.
     * @return operation name
     */
    public String getOperation() {
        return this.operation;
    }
    
    /**
     * Operation name mutator.
     * @param operation operation name
     */
    public void setOperation(String operation) {
        this.operation = operation;
    }
    
    /**
     * Description getter.
     * @return description description
     */
    public String getDescription() {
        return this.description;
    }
    
    /**
     * Description mutator.
     * @param description description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Return type name getter.
     * @return return type
     */
    public String getReturntype() {
        return this.returntype;
    }
    
    /**
     * Return type mutator.
     * @param returntype return type
     */
    public void setReturntype(String returntype) {
        this.returntype = returntype;
    }

    /**
     * Return type name getter.
     * @return return type
     */
    public Boolean getActiveflag() {
        return this.activeflag;
    }
    
    /**
     * Return type mutator.
     * @param returntype return type
     */
    public void setActiveflag(Boolean active) {
        this.activeflag = active;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
    	return 	"OBJECTNAME [" + objectname + "] SERVERNAME[" + servername
    		+ "] OPERATION[" + operation + "] DESCRIPTION[" + description
    		+ "] RETURNTYPE[" + returntype +"] ACTIVEFLAG[" + activeflag + "]";
    }
}


