/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2007
 */

package org.jboss.soa.esb.eclipse.preferences;

import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.swt.widgets.Composite;

/**
 * The Application Server Profile Directory field editor.
 * 
 * @author johnathon
 */
public class ProfileFieldEditor extends DirectoryFieldEditor
{
    /**
     * The enabled flag.
     */
    private boolean enabled ;
    
    /**
     * Construct the Application Server Directory Field Editor.
     * @param parent The parent composite.
     */
    public ProfileFieldEditor(Composite parent)
    {
        super(ESBPreferenceConstants.AS_PROFILE_LOCATION, "&Application Server Profile Location:", parent);
        setEmptyStringAllowed(false) ;
        setErrorMessage("Application Server Profile location does not specify a valid Application Server profile");
    }
    
    /**
     * Check the state after a change.
     * Combo read only drop down limits to valid selections (assuming only directories are in the server dir.)
     * @return true if valid, false otherwise.
     */
    protected boolean doCheckState()
    {
        return true ;
    }
    
    /**
     * Enable or disable the component.
     * @param enabled true if the component is enabled, false otherwise.
     * @param parent The parent composite.
     */
    public void setEnabled(final boolean enabled, final Composite parent)
    {
        this.enabled = enabled ;
        super.setEnabled(enabled, parent);
        setEmptyStringAllowed(!enabled) ;
        if (!enabled)
        {
            setStringValue("") ;
        }
        refreshValidState() ;
    }
}
