/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.graph.exe;

import java.io.Serializable;

import org.apache.commons.lang.enums.ValuedEnum;

/**
 * @author Juan Cant
 * @version $Revision: 1.4 $ $Date: 2007/02/19 22:25:44 $
 */
public abstract class ScopeState extends ValuedEnum implements Serializable {

  /**
   * Constructs a scope state identified by the given name.
   * @param name
   */
  protected ScopeState(String name, int code) {
    super(name, code);    
  }

  public final Class getEnumClass() {
    return ScopeState.class;
  }

  /**
   * Requests cancelation of the scope instance argument.
   * @param scope
   */
  public void terminate(ScopeInstance scope) {
    throw newStateException("terminate");
  }

  /**
   * Requests compensation of the scope instance argument.
   * @param scope
   */
  public void compensate(ScopeInstance scope) {
    throw newStateException("compensate");
  }

  /**
   * Notifies the completion of a scope instance inside an execution flow
   * @param scope
   */
  public void completed(ScopeInstance scope) {
    throw newStateException("completed");
  }

  /**
   * Notifies that a fault occured during the execution of a scope instance
   * @param scope
   */
  public void faulted(ScopeInstance scope) {
    throw newStateException("faulted");
  }

  /**
   * Notifies that the children of the given scope instance were terminated
   * @param scope
   */
  public void childrenTerminated(ScopeInstance scope) {
    throw newStateException("childrenTerminated");
  }

  /**
   * Notifies that the children of the given scope instance were compensated
   * @param scope
   */
  public void childrenCompensated(ScopeInstance scope) {
    throw newStateException("childrenCompensated");
  }

  /**
   * Creates an exception to signal that the given transition is illegal from
   * the current state.
   * @param transition the name of the illegal transition
   * @return a newly created exception
   */
  protected IllegalStateException newStateException(String transition) {
    return new IllegalStateException(this + ": transition=" + transition);
  }
}
