/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.graph.exe.state;

import org.jbpm.bpel.graph.exe.ScopeInstance;
import org.jbpm.bpel.graph.exe.ScopeState;
import org.jbpm.bpel.graph.scope.Handler;

/**
 * @author Juan Cant
 * @version $Revision: 1.7 $ $Date: 2007/03/22 13:32:55 $
 */
public class CompensatingState extends ScopeState {

  private static final long serialVersionUID = 1L;

  public static final ScopeState COMPENSATING_WITHOUT_HANDLER = new CompensatingState(
      "compensatingWithoutHandler", 10) {

    private static final long serialVersionUID = 1L;

    public void faulted(ScopeInstance scope) {
      EndedState.enterFaulted(scope);
    }

    public void childrenCompensated(ScopeInstance scope) {
      EndedState.enterCompensated(scope);
    }
  };

  public static final ScopeState COMPENSATING_WITH_HANDLER = new CompensatingState(
      "compensatingWithHandler", 11) {

    private static final long serialVersionUID = 1L;

    public void completed(ScopeInstance scope) {
      // end handler token (do not verify parent completion)
      scope.getHandlerToken().end(false);
      EndedState.enterCompensated(scope);
    }

    public void faulted(ScopeInstance scope) {
      scope.setState(TERMINATING_COMPENSATION_HANDLER);
      scope.terminateChildren();
    }
  };

  public static final ScopeState TERMINATING_COMPENSATION_HANDLER = new CompensatingState(
      "terminatingCompensationHandler", 12) {

    private static final long serialVersionUID = 1L;

    public void childrenTerminated(ScopeInstance scope) {
      EndedState.enterFaulted(scope);
    }
  };

  private CompensatingState(String name, int code) {
    super(name, code);
  }

  public static void enterCompensating(ScopeInstance scope) {
    Handler handler = scope.getDefinition().getCompensationHandler();

    if (handler != null) {
      scope.setState(COMPENSATING_WITH_HANDLER);
      StateUtil.invokeHandler(scope, handler);
    }
    else {
      scope.setState(COMPENSATING_WITHOUT_HANDLER);
      StateUtil.invokeDefaultCompensation(scope);
    }
  }
}
