/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.par;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.bpel.graph.def.Import;

/**
 * Binding of <tt>bpelDefinition</tt> element.
 * @author Alejandro Guzar
 * @version $Revision: 1.4 $ $Date: 2007/01/22 00:24:55 $
 */
public class DefDescriptor {

  private String location;
  private List imports = new ArrayList();

  public String getLocation() {
    return location;
  }

  public void setLocation(String location) {
    this.location = location;
  }

  public List getImports() {
    return imports;
  }

  public void addImport(Import imp) {
    imports.add(imp);
  }
}
