/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.persistence.db;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;

import org.hibernate.Session;

import org.jbpm.JbpmContext;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.integration.def.PartnerLinkDefinition;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.bpel.integration.exe.PartnerLinkInstance;
import org.jbpm.persistence.PersistenceService;

/**
 * Partner integration database operations.
 * @author Alejandro Guizar
 * @version $Revision: 1.2 $ $Date: 2007/07/20 21:46:36 $
 */
public class IntegrationSession {

  private Session session;

  public IntegrationSession(Session session) {
    this.session = session;
  }

  protected IntegrationSession() {
  }

  public PartnerLinkDefinition loadPartnerLinkDefinition(long id) {
    return (PartnerLinkDefinition) session.load(PartnerLinkDefinition.class, new Long(id));
  }

  public PartnerLinkInstance loadPartnerLinkInstance(long id) {
    return (PartnerLinkInstance) session.load(PartnerLinkInstance.class, new Long(id));
  }

  public ReceiveAction loadReceiveAction(long id) {
    return (ReceiveAction) session.load(ReceiveAction.class, new Long(id));
  }

  public Collection findReceiveTokens(BpelProcessDefinition processDefinition) {
    return session.getNamedQuery("IntegrationSession.findReceiveTokens")
        .setEntity("processDefinition", processDefinition)
        .list();
  }

  public Collection findPickTokens(BpelProcessDefinition processDefinition) {
    List tokens = session.getNamedQuery("IntegrationSession.findPickTokens")
        .setEntity("processDefinition", processDefinition)
        .list();
    // discard duplicates caused by eager collection fetching
    return new HashSet(tokens);
  }

  public Collection findEventTokens(BpelProcessDefinition processDefinition) {
    List tokens = session.getNamedQuery("IntegrationSession.findEventTokens")
        .setEntity("processDefinition", processDefinition)
        .list();
    // discard duplicates caused by eager collection fetching
    return new HashSet(tokens);
  }

  public static IntegrationSession getInstance(JbpmContext jbpmContext) {
    PersistenceService persistenceService = jbpmContext.getServices().getPersistenceService();
    if (persistenceService instanceof DbPersistenceService) {
      DbPersistenceService dbPersistenceService = (DbPersistenceService) persistenceService;
      return dbPersistenceService.getIntegrationSession();
    }
    return null;
  }
}
