/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.sublang.def;

import org.jbpm.bpel.BpelException;
import org.jbpm.bpel.graph.basic.Assign;
import org.jbpm.bpel.sublang.exe.EvaluatorFactory;
import org.jbpm.bpel.sublang.exe.QueryEvaluator;
import org.jbpm.bpel.wsdl.PropertyAlias;
import org.jbpm.bpel.xml.BpelConstants;

/**
 * Queries are used for selection of nodes in {@linkplain Assign assignment} and
 * {@linkplain PropertyAlias property aliases}.
 * @author Alejandro Guizar
 * @version $Revision: 1.5 $ $Date: 2007/05/31 12:55:14 $
 */
public class Query extends Snippet {

  private transient QueryEvaluator evaluator;

  private static final long serialVersionUID = 1L;

  public QueryEvaluator getEvaluator() {
    if (evaluator == null)
      parse();

    return evaluator;
  }

  public void parse() {
    // get language specific to this script
    String language = getLanguage();
    // no specific language, use XPath 1.0
    if (language == null)
      language = BpelConstants.URN_XPATH_1_0;

    // get factory associated to language
    EvaluatorFactory factory = EvaluatorFactory.getInstance(language);
    if (factory == null)
      throw new BpelException("unsupported language: " + language);

    // create expression evaluator
    evaluator = factory.createEvaluator(this);
  }
}
