/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.graph.exe.state;

import org.jbpm.bpel.graph.exe.ScopeState;

/**
 * @author Juan Cantu
 * @version $Revision: 1.2 $ $Date: 2006/10/29 06:13:41 $
 */
public class CompensatingWithoutHandlerTest extends AbstractStateTestCase {

  public ScopeState getState() {
    return CompensatingState.COMPENSATING_WITHOUT_HANDLER;
  }

  public void testChildrenCompensated() {
    scopeInstance.setCompensator(parent);
    scopeInstance.getState().childrenCompensated(scopeInstance);

    assertEquals(EndedState.COMPENSATED, scopeInstance.getState());
    assertTrue(parent.childCompensated);
  }

  public void testChildrenCompensatedAtScope() {
    scopeInstance.setCompensator(parent);
    scopeInstance.getState().childrenCompensated(scopeInstance);

    assertEquals(EndedState.COMPENSATED, scopeInstance.getState());
    assertTrue(parent.childCompensated);
  }

  public void testFaulted() {
    scopeInstance.faulted(null);
    assertEquals(EndedState.FAULTED, scopeInstance.getState());
  }

  public void testFaultedAtScope() {
    scopeInstance.faulted(null);
    assertEquals(EndedState.FAULTED, scopeInstance.getState());
    assertFalse(parent.childCompensated);
    assertTrue(parent.childFaulted);
  }
}
