/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.graph.exe.state;

import org.jbpm.bpel.graph.exe.ScopeState;

/**
 * @author Juan Cantu
 * @version $Revision: 1.1 $ $Date: 2006/10/06 01:52:29 $
 */
public class TerminatingWithoutHandlerTest extends AbstractStateTestCase {

  public ScopeState getState() {
    return TerminatingState.TERMINATING_WITHOUT_HANDLER;
  }

  public void testChildrenCompensated() {
    scopeInstance.getState().childrenCompensated(scopeInstance);

    assertEquals(EndedState.TERMINATED, scopeInstance.getState());
  }

  public void testChildrenCompensatedAtScope() {
    scopeInstance.getState().childrenCompensated(scopeInstance);

    assertEquals(EndedState.TERMINATED, scopeInstance.getState());
    assertTrue(parent.childTerminated);
  }

  public void testFaulted() {
    scopeInstance.faulted(null);
    assertEquals(EndedState.TERMINATED, scopeInstance.getState());
  }

  public void testFaultedAtScope() {
    scopeInstance.faulted(null);
    assertEquals(EndedState.TERMINATED, scopeInstance.getState());
    assertTrue(parent.childTerminated);
  }
}
