package org.jbpm.gd.common.notation;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.jbpm.gd.common.Activator;


public class NotationElementFactory {
	
	private static Map NOTATION_ELEMENT_REGISTRY;
	
	private static Map getNotationElementRegistry() {
		if (NOTATION_ELEMENT_REGISTRY == null) {
			initializeNotationElementRegistry();
		}
		return NOTATION_ELEMENT_REGISTRY;
	}
	
	private static void initializeNotationElementRegistry() {
		NOTATION_ELEMENT_REGISTRY = new HashMap();
		IConfigurationElement[] configurationElements = 
			Platform.getExtensionRegistry().getConfigurationElementsFor("org.jbpm.gd.common.notationElements");
		for (int i = 0; i < configurationElements.length; i++) {
			IConfigurationElement element = configurationElements[i];
			if (element.getName().equals("notationElement")) {
				String key = element.getNamespaceIdentifier() + "." + element.getAttribute("id");
				NOTATION_ELEMENT_REGISTRY.put(key, element);
			}
		}
	}

	public static final NotationElementFactory INSTANCE = new NotationElementFactory();
	
	private Map notationRegistry = new HashMap();
	
	public NotationElement create(String elementType) {
		NotationElement result = null;
		IConfigurationElement element = (IConfigurationElement)getNotationElementRegistry().get(elementType);
		if (element != null) {
			try {
				result = (NotationElement)element.createExecutableExtension("class");
			} catch (CoreException e) {
				Activator.logError("Problem while instantiating notation element for " + elementType, e);
			}
		}
		if (result != null) {
			result.setFactory(this);
		}
		return result;
	}
	
	void register(NotationElement notationElement) {
		notationRegistry.put(notationElement.getSemanticElement(), notationElement);
	}
	
	void unregister(NotationElement notationElement) {
		notationRegistry.remove(notationElement.getSemanticElement());
	}
	
	public NotationElement getRegisteredNotationElementFor(Object semanticElement) {
		return (NotationElement)notationRegistry.get(semanticElement);
	}
	
}
