package org.jbpm.gd.common.notation;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.geometry.Dimension;

public class RootContainer extends NotationElement {
	
	Dimension dimension;
	List nodes = new ArrayList();
	
	public void setDimension(Dimension newDimension) {
		Dimension oldDimension = dimension;
		dimension = newDimension;
		firePropertyChange("dimension", oldDimension, newDimension);
	}
	
	public Dimension getDimension() {
		return dimension;
	}
	
	public void addNode(Node node) {
		nodes.add(node);
		node.setContainer(this);
		firePropertyChange("nodeAdd", null, node);
	}
	
	public void removeNode(Node node) {
		nodes.remove(node);
		node.setContainer(null);
		firePropertyChange("nodeRemove", node, null);
	}
	
	public List getNodes() {
		return nodes;
	}

	public void propertyChange(PropertyChangeEvent evt) {
		firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
	}
	
}
