package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;

import org.jbpm.gd.jpdl.model.AbstractJpdlElement;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.CancelTimer;
import org.jbpm.gd.jpdl.model.Condition;
import org.jbpm.gd.jpdl.model.CreateTimer;
import org.jbpm.gd.jpdl.model.ExceptionHandler;
import org.jbpm.gd.jpdl.model.JpdlElementFactory;
import org.jbpm.gd.jpdl.model.Mail;
import org.jbpm.gd.jpdl.model.Script;
import org.jbpm.gd.jpdl.model.Transition;

public class TransitionDomAdapter extends JpdlElementDomAdapter {
	
	private static final String[] CHILD_ELEMENTS = {"condition", "action-element", "exception-handler"};
	private static HashMap NODE_TYPES = null;
	
	protected String[] getChildElements() {
		return CHILD_ELEMENTS;
	}
	
	protected Map getNodeTypes() {
		if (NODE_TYPES == null) {
			NODE_TYPES = new HashMap();
			NODE_TYPES.put("condition", "condition");
			NODE_TYPES.put("action", "action-element");
			NODE_TYPES.put("script", "action-element");
			NODE_TYPES.put("create-timer", "action-element");
			NODE_TYPES.put("cancel-timer", "action-element");
			NODE_TYPES.put("mail", "action-element");
			NODE_TYPES.put("exception-handler", "exception-handler");
		}
		return NODE_TYPES;
	}
	
	protected void initialize() {
		super.initialize();
		Transition transition = (Transition)getJpdlElement();
		if (transition != null) {
			setAttribute("to", transition.getTo());
			setAttribute("name", transition.getName());
			addElements(transition.getActionElements());
			addElements(transition.getExceptionHandlers());
		}
	}
	
	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		Transition transition = (Transition)jpdlElement;
		transition.setTo(getAttribute("to"));
		transition.setName(getAttribute("name"));
		transition.addPropertyChangeListener(this);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("condition".equals(evt.getPropertyName())) {
			setElement("condition", (AbstractJpdlElement)evt.getOldValue(), (AbstractJpdlElement)evt.getNewValue());
		} else if ("actionAdd".equals(evt.getPropertyName())) {
			addElement((AbstractJpdlElement)evt.getNewValue());
		} else if ("actionRemove".equals(evt.getPropertyName())) {
			removeElement((AbstractJpdlElement)evt.getOldValue());
		} else if ("scriptAdd".equals(evt.getPropertyName())) {
			addElement((AbstractJpdlElement)evt.getNewValue());
		} else if ("scriptRemove".equals(evt.getPropertyName())) {
			removeElement((AbstractJpdlElement)evt.getOldValue());
		} else if ("createTimerAdd".equals(evt.getPropertyName())) {
			addElement((AbstractJpdlElement)evt.getNewValue());
		} else if ("createTimerRemove".equals(evt.getPropertyName())) {
			removeElement((AbstractJpdlElement)evt.getOldValue());
		} else if ("cancelTimerAdd".equals(evt.getPropertyName())) {
			addElement((AbstractJpdlElement)evt.getNewValue());
		} else if ("cancelTimerRemove".equals(evt.getPropertyName())) {
			removeElement((AbstractJpdlElement)evt.getOldValue());
		} else if ("mailAdd".equals(evt.getPropertyName())) {
			addElement((AbstractJpdlElement)evt.getNewValue());
		} else if ("mailRemove".equals(evt.getPropertyName())) {
			removeElement((AbstractJpdlElement)evt.getOldValue());
		} else if ("exceptionHandlerAdd".equals(evt.getPropertyName())) {
			addElement((ExceptionHandler)evt.getNewValue());
		} else if ("exceptionHandlerRemove".equals(evt.getPropertyName())) {
			removeElement((ExceptionHandler)evt.getOldValue());
		} else if ("to".equals(evt.getPropertyName())) {
			setAttribute("to", (String)evt.getNewValue());
		} else if ("name".equals(evt.getPropertyName())) {
			setAttribute("name", (String)evt.getNewValue());
		}
	}
	
	protected void doModelUpdate(String name, String newValue) {
		Transition transition = (Transition)getJpdlElement();
		if ("to".equals(name)) {
			transition.setTo(newValue);
		} else if ("name".equals(name)) {
			transition.setName(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		Transition transition = (Transition)getJpdlElement();
		AbstractJpdlElement jpdlElement = JpdlElementFactory.INSTANCE.createByName(child.getElementType());
		child.initialize(jpdlElement);
		if ("condition".equals(type)) {
			transition.setCondition((Condition)jpdlElement);
		} else if ("action".equals(type)) {
			transition.addActionElement((Action)jpdlElement);
		} else if ("script".equals(type)) {
			transition.addActionElement((Script)jpdlElement);
		} else if ("create-timer".equals(type)) {
			transition.addActionElement((CreateTimer)jpdlElement);
		} else if ("cancel-timer".equals(type)) {
			transition.addActionElement((CancelTimer)jpdlElement);
		} else if ("mail".equals(type)) {
			transition.addActionElement((Mail)jpdlElement);
		} else if ("exception-handler".equals(type)) {
			transition.addExceptionHandler((ExceptionHandler)jpdlElement);
		}
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		Transition transition = (Transition)getJpdlElement();
		if ("condition".equals(type)) {
			transition.setCondition(null);
		} else if ("action".equals(type)) {
			transition.removeActionElement((Action)child.getJpdlElement());
		} else if ("script".equals(type)) {
			transition.removeActionElement((Script)child.getJpdlElement());
		} else if ("create-timer".equals(type)) {
			transition.removeActionElement((CreateTimer)child.getJpdlElement());
		} else if ("cancel-timer".equals(type)) {
			transition.removeActionElement((CancelTimer)child.getJpdlElement());
		} else if ("mail".equals(type)) {
			transition.removeActionElement((Mail)child.getJpdlElement());
		} else if ("exception-handler".equals(type)) {
			transition.removeExceptionHandler((ExceptionHandler)child.getJpdlElement());
		}
	}

}
