package org.jbpm.gd.jpdl.ui.editor;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.notation.NotationElementFactory;
import org.jbpm.gd.jpdl.ui.graph.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.jpdl.ui.outline.part.JpdlElementOutlineEditPart;
import org.jbpm.gd.jpdl.ui.outline.part.NodeElementOutlineEditPart;
import org.jbpm.gd.jpdl.ui.outline.part.ProcessDefinitionOutlineEditPart;
import org.jbpm.gd.jpdl.ui.outline.part.TransitionOutlineEditPart;

public class JpdlSelectionSynchronizer extends SelectionSynchronizer {
	
	protected EditPart convert(EditPartViewer viewer, EditPart part) {
		if (viewer instanceof JpdlModelGraphicalViewer && part instanceof JpdlElementOutlineEditPart) {
			part = getSelectablePartInGraphicalViewer(part);
			AbstractNotationElement notationElement = NotationElementFactory.INSTANCE.getRegisteredNotationElementFor(part.getModel());
			if (notationElement != null) {
				return (EditPart)viewer.getEditPartRegistry().get(notationElement);
			}
		}
		if (viewer instanceof TreeViewer && part instanceof NotationElementGraphicalEditPart) {
			Object semanticElement = ((AbstractNotationElement)part.getModel()).getSemanticElement();
			if (semanticElement != null) {
				return (EditPart)viewer.getEditPartRegistry().get(semanticElement);
			}
		}
		return null;
	}
	
	private EditPart getSelectablePartInGraphicalViewer(EditPart part) {
		while (!isSelectablePartInGraphicalViewer(part)) {
			if (part.getParent() == null) break;
			part = part.getParent();
		}
		return part;
	}
	
	private boolean isSelectablePartInGraphicalViewer(EditPart part) {
		return part instanceof ProcessDefinitionOutlineEditPart ||
			part instanceof NodeElementOutlineEditPart ||
			part instanceof TransitionOutlineEditPart;
	}

}
