package org.jbpm.gd.jpdl.ui.properties;

import org.eclipse.jface.viewers.IFilter;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.Transition;
import org.jbpm.gd.jpdl.ui.graph.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.jpdl.ui.outline.part.JpdlOutlineEditPart;

public class EventFilter implements IFilter {
	
	public boolean select(Object toTest) {
		Object input = toTest;
        if (toTest instanceof NotationElementGraphicalEditPart) {
        	AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)toTest).getNotationElement();
        	input = notationElement.getSemanticElement();
        } else if (toTest instanceof JpdlOutlineEditPart) {
        	input = ((JpdlOutlineEditPart)toTest).getModel();
        }
		return input instanceof Event && !(input instanceof Transition);
	}

}
