package org.jbpm.scheduler.ejbtimer;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.TimedObject;
import javax.ejb.TimerHandle;
import javax.ejb.TimerService;
import javax.naming.Context;
import javax.naming.InitialContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmException;
import org.jbpm.ejb.LocalCommandService;
import org.jbpm.ejb.LocalCommandServiceHome;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Timer;

public abstract class TimerEntityBean implements EntityBean, TimedObject {

	private Log log = LogFactory.getLog(this.getClass());

	private EntityContext ctx;

	private TimerHandle timerHandle = null;

	public TimerEntityBean() {}

	public abstract Long getTimerID();

	public abstract void setTimerID(Long timerID);

	public abstract String getName();

	public abstract void setName(String name);

	public abstract String getRepeat();

	public abstract void setRepeat(String repeat);

	public abstract void setDueDate(Date dueDate);

	public abstract Date getDueDate();

	public abstract void setTokenId(long tokenId);

	public abstract long getTokenId();

	public abstract void setProcessInstanceId(long processInstanceId);

	public abstract long getProcessInstanceId();

	public void ejbActivate() {}

	public void ejbRemove() {}

	public void ejbPassivate() {}

	public void ejbLoad() {}

	public void ejbStore() {}

	public void setEntityContext(EntityContext ctx) {
		this.ctx = ctx;
	}

	public void unsetEntityContext() {
		this.ctx = null;
	}

	public void ejbPostCreate() {}

	/**
	 * No ejbCreate operation is allowed. One approach of ensuring that an EJB is
	 * set as read-only.
	 * 
	 * @throws CreateException
	 */
	public Long ejbCreate() throws CreateException {
		throw new CreateException(
				"EJB is read-only, cannot create instances, the usage of ejbCreate() is prohibited in this context");
	}

	public void ejbTimeout(javax.ejb.Timer ejbTimer) {
		log.debug("ejb timer " + ejbTimer + " fires");
		String localCommandServiceJndiName = "java:comp/env/ejb/LocalCommandServiceBean";
		try {
			Context initial = new InitialContext();
			LocalCommandServiceHome localCommandServiceHome = (LocalCommandServiceHome) initial
					.lookup(localCommandServiceJndiName);
			LocalCommandService localCommandService = localCommandServiceHome
					.create();
			Serializable info = ejbTimer.getInfo();
			if(!(info instanceof TimerInfo)) {
				if(info == null) {
					throw new NullPointerException("timer info is null");
				}
				else {
					throw new ClassCastException("timer info ("
							+ info.getClass().getName() + ") is not of the expected class "
							+ TimerInfo.class.getName());
				}
			}
			TimerInfo timerInfo = (TimerInfo) info;
			Timer timer = (Timer) localCommandService
					.execute(new ExecuteTimerCommand(timerInfo.getTimerId()));
			// if the timer has repeat
			if((timer != null) && (timer.getRepeat() != null)) {
				// create a new timer
				log.debug("scheduling timer for repeat at " + timer.getDueDate());
				createTimer(timer);
			}
		}
		catch(Exception e) {
			JbpmException jbpmException = new JbpmException("couldn't execute timer",
					e);
			log.error(jbpmException);
			throw jbpmException;
		}
	}

	public void createTimer(org.jbpm.job.Timer timer) {
		log.debug("Creating timer " + timer + " in the ejb timer service");
		TimerService timerService = ctx.getTimerService();
		timerService.createTimer(timer.getDueDate(), new TimerInfo(timer));
	}

	public void cancelTimer() {
		log.debug("Cancelling timer: " + this.getName());
		TimerService ts = ctx.getTimerService();
		java.util.Collection timers = ts.getTimers();
		if(timers != null) {
			Iterator it = timers.iterator();
			while(it.hasNext()) {
				javax.ejb.Timer timer = (javax.ejb.Timer) it.next();
				timer.cancel();
			}
		}
		return;
	}

	public void cancelTimersByName(String timerName, Token token) {
		log.debug("cancelling timers with name " + timerName
				+ " from the ejb timer service");
		TimerService timerService = ctx.getTimerService();
		Iterator iter = timerService.getTimers().iterator();
		while(iter.hasNext()) {
			javax.ejb.Timer ejbTimer = (javax.ejb.Timer) iter.next();
			if(ejbTimer.getInfo() instanceof TimerInfo) {
				TimerInfo timerInfo = (TimerInfo) ejbTimer.getInfo();
				if(timerInfo.matchesName(timerName, token)) {
					ejbTimer.cancel();
				}
			}
		}
	}

	public void deleteTimersForProcessInstance(ProcessInstance processInstance) {
		log.debug("deleting timers for process instance " + processInstance
				+ " from the ejb timer service");
		TimerService timerService = ctx.getTimerService();
		Iterator iter = timerService.getTimers().iterator();
		while(iter.hasNext()) {
			javax.ejb.Timer ejbTimer = (javax.ejb.Timer) iter.next();
			if(ejbTimer.getInfo() instanceof TimerInfo) {
				TimerInfo timerInfo = (TimerInfo) ejbTimer.getInfo();
				if(timerInfo.matchesProcessInstance(processInstance)) {
					ejbTimer.cancel();
				}
			}
		}
	}

}
