/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.factory;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.jboss.spring.factory.Instantiable;
import org.jboss.spring.factory.Nameable;
import org.jboss.util.naming.Util;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.xml.DefaultBeanDefinitionDocumentReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NamedXmlBeanDefinitionParser
extends DefaultBeanDefinitionDocumentReader
implements Nameable,
Instantiable {
    protected static Logger log = Logger.getLogger(NamedXmlBeanDefinitionParser.class);
    public static final String BEAN_FACTORY_ELEMENT = "BeanFactory=\\(([^)]+)\\)";
    public static final String PARENT_BEAN_FACTORY_ELEMENT = "ParentBeanFactory=\\(([^)]+)\\)";
    public static final String INSTANTIATION_ELEMENT = "Instantiate=\\(([^)]+)\\)";
    private ConfigurableBeanFactory beanFactory;
    private String beanFactoryName;
    private boolean instantiate;

    public NamedXmlBeanDefinitionParser(ConfigurableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected void preProcessXml(Element root) throws BeanDefinitionStoreException {
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Matcher inst;
            Matcher pbfm;
            Matcher bfm;
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            if (!"description".equals(node.getNodeName())) continue;
            String nodeValue = ele.getFirstChild().getNodeValue();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Bean names [description tag]: " + nodeValue));
            }
            if ((bfm = NamedXmlBeanDefinitionParser.parse(nodeValue, BEAN_FACTORY_ELEMENT)).find()) {
                this.beanFactoryName = bfm.group(1);
            }
            if ((pbfm = NamedXmlBeanDefinitionParser.parse(nodeValue, PARENT_BEAN_FACTORY_ELEMENT)).find()) {
                String parentBeanFactoryName = pbfm.group(1);
                try {
                    this.beanFactory.setParentBeanFactory((BeanFactory)Util.lookup((String)parentBeanFactoryName, BeanFactory.class));
                }
                catch (Exception e) {
                    throw new BeanDefinitionStoreException("Failure during parent bean factory JNDI lookup: " + parentBeanFactoryName, (Throwable)e);
                }
            }
            if (!(inst = NamedXmlBeanDefinitionParser.parse(nodeValue, INSTANTIATION_ELEMENT)).find()) continue;
            this.instantiate = Boolean.parseBoolean(inst.group(1));
        }
    }

    public String getName() {
        return this.beanFactoryName;
    }

    public boolean doInstantiate() {
        return this.instantiate;
    }

    private static Matcher parse(String value, String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        return pattern.matcher(value);
    }
}

