/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCIPAnnotationDatabase {
    Map<ClassMember, Map<String, Object>> memberAnnotations = new HashMap<ClassMember, Map<String, Object>>();
    Map<String, Map<String, Object>> classAnnotations = new HashMap<String, Map<String, Object>>();

    public Object getClassAnnotation(String dottedClassName, String annotationClass) {
        assert (dottedClassName.indexOf(47) == -1);
        return this.getEntryForClass(dottedClassName).get(annotationClass);
    }

    public boolean hasClassAnnotation(String dottedClassName, String annotationClass) {
        assert (dottedClassName.indexOf(47) == -1);
        return this.getEntryForClass(dottedClassName).containsKey(annotationClass);
    }

    public Object getFieldAnnotation(XField field, String annotationClass) {
        return this.getEntryForClassMember(field).get(annotationClass);
    }

    public boolean hasFieldAnnotation(XField field, String annotationClass) {
        return this.getEntryForClassMember(field).containsKey(annotationClass);
    }

    public Object getMethodAnnotation(XMethod method, String annotationClass) {
        return this.getEntryForClassMember(method).get(annotationClass);
    }

    public boolean hasMethodAnnotation(XMethod method, String annotationClass) {
        return this.getEntryForClassMember(method).containsKey(annotationClass);
    }

    public Map<String, Object> getEntryForClassMember(ClassMember member) {
        Map<String, Object> map = this.memberAnnotations.get(member);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.memberAnnotations.put(member, map);
        }
        return map;
    }

    public Map<String, Object> getEntryForClass(String dottedClassName) {
        assert (dottedClassName.indexOf(47) == -1);
        Map<String, Object> map = this.classAnnotations.get(dottedClassName);
        if (map == null) {
            map = new HashMap<String, Object>(3);
            this.classAnnotations.put(dottedClassName, map);
        }
        return map;
    }
}

