/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.classfile.ICodeBase;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.ICodeBaseIterator;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import edu.umd.cs.findbugs.classfile.impl.AbstractScannableCodeBase;
import edu.umd.cs.findbugs.classfile.impl.DelegatingCodeBaseEntry;
import edu.umd.cs.findbugs.classfile.impl.DelegatingCodeBaseIterator;
import edu.umd.cs.findbugs.classfile.impl.NestedZipFileCodeBaseLocator;
import edu.umd.cs.findbugs.classfile.impl.ZipCodeBaseFactory;
import edu.umd.cs.findbugs.io.IO;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NestedZipFileCodeBase
extends AbstractScannableCodeBase {
    private ICodeBase parentCodeBase;
    private String resourceName;
    private File tempFile;
    private AbstractScannableCodeBase delegateCodeBase;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NestedZipFileCodeBase(NestedZipFileCodeBaseLocator codeBaseLocator) throws ResourceNotFoundException, IOException {
        BufferedOutputStream outputStream;
        block9: {
            ICodeBaseEntry resource;
            InputStream inputStream;
            block7: {
                block8: {
                    super(codeBaseLocator);
                    this.parentCodeBase = codeBaseLocator.getParentCodeBase();
                    this.resourceName = codeBaseLocator.getResourceName();
                    inputStream = null;
                    outputStream = null;
                    try {
                        this.tempFile = File.createTempFile("findbugs", ".zip");
                        this.tempFile.deleteOnExit();
                        resource = this.parentCodeBase.lookupResource(this.resourceName);
                        if (resource != null) break block7;
                        if (inputStream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            IO.close(inputStream);
                        }
                        if (outputStream != null) {
                            IO.close(outputStream);
                        }
                        throw throwable;
                    }
                    IO.close(inputStream);
                }
                if (outputStream != null) {
                    IO.close(outputStream);
                }
                return;
            }
            inputStream = resource.openResource();
            outputStream = new BufferedOutputStream(new FileOutputStream(this.tempFile));
            IO.copy(inputStream, outputStream);
            ((OutputStream)outputStream).flush();
            this.delegateCodeBase = ZipCodeBaseFactory.makeZipCodeBase(codeBaseLocator, this.tempFile);
            if (inputStream == null) break block9;
            IO.close(inputStream);
        }
        if (outputStream != null) {
            IO.close(outputStream);
        }
    }

    public ICodeBaseIterator iterator() throws InterruptedException {
        return new DelegatingCodeBaseIterator(this, this.delegateCodeBase);
    }

    public ICodeBaseEntry lookupResource(String resourceName) {
        ICodeBaseEntry delegateCodeBaseEntry = this.delegateCodeBase.lookupResource(resourceName);
        if (delegateCodeBaseEntry == null) {
            return null;
        }
        return new DelegatingCodeBaseEntry(this, delegateCodeBaseEntry);
    }

    public String getPathName() {
        return null;
    }

    public void close() {
        this.delegateCodeBase.close();
        if (!this.tempFile.delete()) {
            AnalysisContext.logError("Could not delete " + this.tempFile);
        }
    }
}

