/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.FindBugsCommandLine;
import edu.umd.cs.findbugs.gui2.GUISaveState;
import java.io.File;
import java.io.IOException;
import javax.swing.UIManager;

public class GUI2CommandLine
extends FindBugsCommandLine {
    private float fontSize = 12.0f;
    private boolean fontSizeSpecified = false;
    private boolean docking = true;
    private int priority = 4;
    private File saveFile;

    public GUI2CommandLine() {
        this.addOption("-f", "font size", "set font size");
        this.addSwitch("-clear", "clear saved GUI settings and exit");
        this.addOption("-priority", "thread priority", "set analysis thread priority");
        this.addOption("-loadbugs", "saved analysis results", "load bugs from saved analysis results");
        this.addSwitch("-d", "disable docking");
        this.addSwitch("--nodock", "disable docking");
        this.addSwitchWithOptionalExtraPart("-look", "plastic|gtk|native", "set UI look and feel");
    }

    protected void handleOption(String option, String optionExtraPart) {
        if (option.equals("-clear")) {
            GUISaveState.clear();
            System.exit(0);
        } else if (option.equals("-d") || option.equals("--nodock")) {
            this.docking = false;
        } else if (option.equals("-look")) {
            String arg = optionExtraPart;
            String theme = null;
            if (arg.equals("plastic")) {
                theme = "com.jgoodies.plaf.plastic.PlasticXPLookAndFeel";
            } else if (arg.equals("gtk")) {
                theme = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            } else if (arg.equals("native")) {
                theme = UIManager.getSystemLookAndFeelClassName();
            } else {
                System.err.println("Style '" + arg + "' not supported");
            }
            if (theme != null) {
                try {
                    UIManager.setLookAndFeel(theme);
                }
                catch (Exception e) {
                    System.err.println("Couldn't load " + arg + " look and feel: " + e.toString());
                }
            }
        } else {
            super.handleOption(option, optionExtraPart);
        }
    }

    protected void handleOptionWithArgument(String option, String argument) throws IOException {
        if (option.equals("-f")) {
            try {
                this.fontSize = Float.parseFloat(argument);
                this.fontSizeSpecified = true;
            }
            catch (NumberFormatException e) {}
        } else if (option.equals("-priority")) {
            try {
                this.priority = Integer.parseInt(argument);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (option.equals("-loadBugs")) {
            this.saveFile = new File(argument);
            if (!this.saveFile.exists()) {
                System.err.println("Bugs file \"" + argument + "\" could not be found");
                System.exit(1);
            }
        } else {
            super.handleOptionWithArgument(option, argument);
        }
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public boolean isFontSizeSpecified() {
        return this.fontSizeSpecified;
    }

    public boolean getDocking() {
        return this.docking;
    }

    public void setDocking(boolean docking) {
        this.docking = docking;
    }

    public int getPriority() {
        return this.priority;
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    public void setSaveFile(File saveFile) {
        this.saveFile = saveFile;
    }
}

