/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.jms;

import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;
import org.mockejb.jms.MockProducer;
import org.mockejb.jms.MockQueue;

class QueueSenderImpl
extends MockProducer
implements QueueSender {
    QueueSenderImpl(MockQueue queue) {
        super(queue);
    }

    public Queue getQueue() throws JMSException {
        return (Queue)this.getDestination();
    }

    public void send(Queue queue, Message msg) throws JMSException {
        this.send(queue, msg, this.getDeliveryMode(), this.getPriority(), 0L);
    }

    public void send(Queue queue, Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkDestination(true);
        if (queue instanceof MockQueue) {
            MockProducer.sendMessage((MockQueue)queue, msg, deliveryMode, priority, timeToLive);
        }
        throw new InvalidDestinationException("Invalid queue specified!");
    }
}

