/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.converters.xstream.conf;

import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassAliasConf {
    private String alias;
    private Class<?> type;
    private Class<?> defaultType;

    public ClassAliasConf(String alias, String type, String defaultType) {
        AssertArgument.isNotNullAndNotEmpty(alias, "alias");
        AssertArgument.isNotNullAndNotEmpty(type, "type");
        this.alias = alias;
        this.type = this.loadClass(type);
        if (defaultType != null) {
            this.defaultType = this.loadClass(defaultType);
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getDefaultType() {
        return this.defaultType;
    }

    public String toString() {
        return "ClassAliasConf [alias=" + this.alias + ", type=" + this.type + ", defaultType=" + this.defaultType + "]";
    }

    private Class<?> loadClass(String className) {
        try {
            return ClassUtil.forName(className, this.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load class '" + className + "'", e);
        }
    }
}

