/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.common;

import com.arjuna.common.internal.util.propertyservice.PropertyManagerImpl;
import com.arjuna.common.internal.util.propertyservice.plugins.io.XMLFilePlugin;
import com.arjuna.common.util.exceptions.LoadPropertiesException;
import com.arjuna.common.util.propertyservice.PropertyManager;
import com.arjuna.common.util.propertyservice.PropertyManagerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.FatalError;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModulePropertyManager {
    public static final String CORE_MODULE = "core";
    public static final String CONNECTION_MODULE = "connection";
    public static final String REGISTRY_MODULE = "registry";
    public static final String TRANSPORTS_MODULE = "transports";
    public static final String DBSTORE_MODULE = "dbstore";
    public static final String FILTER_MODULE = "filters";
    public static final String SECURITY_MODULE = "security";
    public static final String JCA_MODULE = "jca";
    public static final String RULES_MODULE = "rules";
    private static Hashtable<String, PropertyManager> managers = new Hashtable();
    private static Logger _logger = Logger.getLogger(ModulePropertyManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyManager getPropertyManager(String name) {
        Hashtable<String, PropertyManager> hashtable = managers;
        synchronized (hashtable) {
            PropertyManager theManager = managers.get(name);
            if (theManager == null && (theManager = ModulePropertyManager.initialise(name)) != null) {
                managers.put(name, theManager);
            }
            return theManager;
        }
    }

    private static final PropertyManager initialise(String name) {
        try {
            PropertyManager propertyManager = PropertyManagerFactory.getPropertyManager((String)("org.jboss.soa.esb.propertymanager." + name), (String)name);
            String propertiesFilename = System.getProperty("org.jboss.soa.esb.propertyFile", "jbossesb-properties.xml");
            try {
                propertyManager.load(XMLFilePlugin.class.getName(), propertiesFilename);
            }
            catch (LoadPropertiesException ex) {
                _logger.fatal((Object)("ModulePropertyManager failed to load property file " + propertiesFilename));
                throw new FatalError(ex);
            }
            catch (ClassNotFoundException e) {
                _logger.fatal((Object)"ModulePropertyManager failed to load XML plugin", (Throwable)e);
                throw new FatalError(e);
            }
            return propertyManager;
        }
        catch (Exception e) {
            _logger.fatal((Object)"ModulePropertyManager failed to load PropertyManager", (Throwable)e);
            throw new FatalError(e);
        }
    }

    public static void configure(InputStream esbConfig) throws IOException, SAXException {
        AssertArgument.isNotNull(esbConfig, "esbConfig");
        managers.clear();
        Document configDoc = YADOMUtil.parseStream(esbConfig, false, false);
        NodeList propertiesList = configDoc.getElementsByTagName("properties");
        for (int i = 0; i < propertiesList.getLength(); ++i) {
            Element properties = (Element)propertiesList.item(i);
            String name = properties.getAttribute("name");
            PropertyManagerImpl propertyManager = new PropertyManagerImpl(name);
            NodeList propertyList = properties.getElementsByTagName("property");
            ModulePropertyManager.addProperties(propertyList, (PropertyManager)propertyManager);
            managers.put(name, (PropertyManager)propertyManager);
        }
    }

    private static void addProperties(NodeList propertyList, PropertyManager propertyManager) {
        for (int i = 0; i < propertyList.getLength(); ++i) {
            Element property = (Element)propertyList.item(i);
            String name = property.getAttribute("name");
            String value = property.getAttribute("value");
            propertyManager.setProperty(name, value);
        }
    }

    public static Hashtable<String, PropertyManager> getManagers() {
        return managers;
    }

    public static void setManagers(Hashtable<String, PropertyManager> managers) {
        ModulePropertyManager.managers = managers;
    }
}

