/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.helpers;

import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyValuePair
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String mKey;
    private String mVal;

    public KeyValuePair(String pKey, String pVal) {
        if (pKey == null || pKey.trim().equals("")) {
            throw new IllegalArgumentException("null or empty 'pKey' arg in call.");
        }
        this.mKey = pKey;
        this.mVal = pVal;
    }

    public String getKey() {
        return this.mKey;
    }

    public String getValue() {
        return this.mVal;
    }

    public String toString() {
        return this.mVal;
    }

    public String dump() {
        return "KVpair[" + this.mKey + "=" + this.mVal + "]";
    }

    public static String getValue(String key, List<KeyValuePair> list) {
        if (key == null) {
            throw new IllegalArgumentException("null 'key' arg in call.");
        }
        if (list == null) {
            throw new IllegalArgumentException("null 'list' arg in call.");
        }
        for (KeyValuePair kvp : list) {
            if (!kvp.mKey.equals(key)) continue;
            return kvp.mVal;
        }
        return null;
    }

    public static String getValue(String key, List<KeyValuePair> list, String defaultVal) {
        String value = KeyValuePair.getValue(key, list);
        if (value == null) {
            return defaultVal;
        }
        return value;
    }

    public static boolean getBooleanValue(String key, List<KeyValuePair> list, boolean defaultVal) {
        String value = KeyValuePair.getValue(key, list);
        if (value == null) {
            return defaultVal;
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("y") || value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("n") || value.equalsIgnoreCase("no")) {
            return false;
        }
        return defaultVal;
    }

    public static double getDoubleValue(String key, List<KeyValuePair> list, double defaultVal) {
        String value = KeyValuePair.getValue(key, list);
        if (value == null) {
            return defaultVal;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return defaultVal;
        }
    }
}

