/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.http.configurators;

import java.util.Properties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.http.Configurator;

public class Connection
extends Configurator {
    private Logger logger = Logger.getLogger(Connection.class);
    public static final String MAX_TOTAL_CONNECTIONS = "max-total-connections";
    public static final String MAX_CONNECTIONS_PER_HOST = "max-connections-per-host";

    public void configure(HttpClient httpClient, Properties properties) throws ConfigurationException {
        HttpConnectionManagerParams params;
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        String maxTotalConnections = properties.getProperty(MAX_TOTAL_CONNECTIONS);
        String maxConnectionsPerHost = properties.getProperty(MAX_CONNECTIONS_PER_HOST);
        if (maxTotalConnections != null) {
            params = this.getConnectionManagerParams((HttpConnectionManager)connectionManager);
            try {
                params.setMaxTotalConnections(Integer.parseInt(maxTotalConnections.trim()));
            }
            catch (NumberFormatException nfe) {
                throw new ConfigurationException("Invalid max-total-connections property: " + maxTotalConnections);
            }
        }
        if (maxConnectionsPerHost != null) {
            params = this.getConnectionManagerParams((HttpConnectionManager)connectionManager);
            try {
                params.setMaxConnectionsPerHost(httpClient.getHostConfiguration(), Integer.parseInt(maxConnectionsPerHost.trim()));
            }
            catch (NumberFormatException nfe) {
                throw new ConfigurationException("Invalid max-connections-per-host property: " + maxConnectionsPerHost);
            }
        }
        httpClient.setHttpConnectionManager((HttpConnectionManager)connectionManager);
    }

    private HttpConnectionManagerParams getConnectionManagerParams(HttpConnectionManager connectionManager) {
        HttpConnectionManagerParams params = connectionManager.getParams();
        if (params == null) {
            params = new HttpConnectionManagerParams();
            connectionManager.setParams(params);
        }
        return params;
    }
}

