/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.gateway.DefaultESBPropertiesSetter;
import org.jboss.soa.esb.listeners.gateway.ESBPropertiesSetter;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.message.format.MessageFactory;

public class PackageJmsMessageContents {
    private Logger log = Logger.getLogger(PackageJmsMessageContents.class);
    private ESBPropertiesSetter esbPropertiesStrategy = new DefaultESBPropertiesSetter();
    private MessagePayloadProxy payloadProxy;

    public PackageJmsMessageContents(ConfigTree config) {
        this(PackageJmsMessageContents.createPayloadProxy(config));
        String excludeProperties = config.getAttribute("excludeProperties");
        if (excludeProperties != null) {
            this.esbPropertiesStrategy = new DefaultESBPropertiesSetter(excludeProperties);
        }
    }

    public PackageJmsMessageContents(MessagePayloadProxy payloadProxy) {
        this.payloadProxy = payloadProxy;
    }

    public Message process(Object obj) throws JMSException, IOException, MessageDeliverException {
        if (!(obj instanceof javax.jms.Message)) {
            throw new IllegalArgumentException("Object must be instance of javax.jms.Message");
        }
        javax.jms.Message jmsMessage = (javax.jms.Message)obj;
        Message esbMessage = MessageFactory.getInstance().getMessage();
        this.setESBMessageBody(jmsMessage, esbMessage);
        try {
            if (this.payloadProxy.getPayload(esbMessage) == null) {
                return null;
            }
        }
        catch (MessageDeliverException e) {
            return null;
        }
        this.setPropertiesFromJMSMessage(jmsMessage, esbMessage);
        return esbMessage;
    }

    public void setEsbPropertiesStrategy(ESBPropertiesSetter esbPropertiesStrategy) {
        this.esbPropertiesStrategy = esbPropertiesStrategy;
    }

    protected void setPropertiesFromJMSMessage(javax.jms.Message fromJMS, Message toESB) throws JMSException {
        this.esbPropertiesStrategy.setPropertiesFromJMSMessage(fromJMS, toESB);
    }

    private void setESBMessageBody(javax.jms.Message fromJMSMessage, Message toESBMessage) throws JMSException, IOException, MessageDeliverException {
        byte[] bodyAsBytes = null;
        if (fromJMSMessage instanceof TextMessage) {
            String text = ((TextMessage)fromJMSMessage).getText();
            this.payloadProxy.setPayload(toESBMessage, text);
        } else if (fromJMSMessage instanceof BytesMessage) {
            int iQread;
            BytesMessage jBytes = (BytesMessage)fromJMSMessage;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] ba = new byte[1000];
            while (-1 != (iQread = jBytes.readBytes(ba))) {
                if (iQread > 0) {
                    out.write(ba, 0, iQread);
                }
                out.close();
            }
            bodyAsBytes = out.toByteArray();
            this.payloadProxy.setPayload(toESBMessage, bodyAsBytes);
        } else if (fromJMSMessage instanceof ObjectMessage) {
            Serializable object = ((ObjectMessage)fromJMSMessage).getObject();
            this.payloadProxy.setPayload(toESBMessage, object);
        } else {
            this.log.warn((Object)("Message type " + fromJMSMessage.getClass().getSimpleName() + " not supported - Message is ignored"));
        }
    }

    public static MessagePayloadProxy createPayloadProxy(ConfigTree config) {
        return new MessagePayloadProxy(config, new String[]{"org.jboss.soa.esb.message.content.bytes"}, new String[]{"org.jboss.soa.esb.message.defaultEntry", "org.jboss.soa.esb.message.content.bytes"});
    }
}

