/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.message;

import java.sql.Timestamp;
import org.jboss.soa.esb.listeners.message.MessageStatusBean;

public class MessageCounterStatistics {
    private static final MessageCounterStatistics SINGLETON = new MessageCounterStatistics();
    private long lastSuccessfulMessageDate;
    private long lastFailedMessageDate;
    private int failedMessageCount;
    private int successMessageCount;
    private long totalProcessTime;
    private long bytesProcessed;
    private long bytesFailed;

    public MessageCounterStatistics() {
        this.resetCounts();
    }

    public synchronized int getFailedMessageCount() {
        return this.failedMessageCount;
    }

    public synchronized String getLastSuccessfulMessageDate() {
        return MessageCounterStatistics.getDate(this.lastSuccessfulMessageDate);
    }

    public synchronized String getLastFailedMessageDate() {
        return MessageCounterStatistics.getDate(this.lastFailedMessageDate);
    }

    public synchronized int getTotalMessageCount() {
        return this.failedMessageCount + this.successMessageCount;
    }

    public synchronized int getSuccessfulMessageCount() {
        return this.successMessageCount;
    }

    public synchronized long getProcessedBytes() {
        return this.bytesProcessed;
    }

    public synchronized long getFailedBytes() {
        return this.bytesFailed;
    }

    public synchronized void update(MessageStatusBean msb) {
        if (msb.getMessageStatus().equals("SENT")) {
            ++this.successMessageCount;
            if (msb.getMessageTime() > this.lastSuccessfulMessageDate) {
                this.lastSuccessfulMessageDate = msb.getMessageTime();
            }
            this.bytesProcessed += msb.getMessageBytes();
        } else if (msb.getMessageStatus().equals("FAILED")) {
            ++this.failedMessageCount;
            if (msb.getMessageTime() > this.lastFailedMessageDate) {
                this.lastFailedMessageDate = msb.getMessageTime();
            }
            this.bytesFailed += msb.getMessageBytes();
        }
        this.totalProcessTime += msb.getProcessTime();
    }

    public synchronized Double getAverageSuccessTime() {
        if (this.successMessageCount > 0) {
            double ms = (double)this.totalProcessTime / (double)(1000000 * this.successMessageCount);
            return new Double(ms);
        }
        return null;
    }

    public synchronized void resetCounts() {
        this.lastSuccessfulMessageDate = 0L;
        this.lastFailedMessageDate = 0L;
        this.successMessageCount = 0;
        this.failedMessageCount = 0;
        this.totalProcessTime = 0L;
        this.bytesProcessed = 0L;
        this.bytesFailed = 0L;
    }

    private static String getDate(long time) {
        if (time <= 0L) {
            return "---";
        }
        Timestamp ts = new Timestamp(time);
        return ts.toString();
    }

    public static MessageCounterStatistics getMessageCounterStatistics() {
        return SINGLETON;
    }
}

