/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.notification;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Map;
import org.jboss.internal.soa.esb.notification.MacroExpander;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.notification.NotificationList;
import org.jboss.soa.esb.services.NotificationManager;

public class NotifyUtil {
    public static void notifyOK(NotificationManager p_oNH, ConfigTree p_oParent, Serializable p_o, Map p_oCtx) {
        try {
            ConfigTree[] oaP = p_oParent.getChildren("NotificationList");
            for (int i1 = 0; i1 < oaP.length; ++i1) {
                NotificationList oCurr = new NotificationList(oaP[i1]);
                if (!oCurr.isOK()) continue;
                ConfigTree oCpy = oaP[i1].cloneObj();
                MacroExpander.replaceMacros(oCpy, p_oCtx);
                p_oNH.sendNotifications(oCpy, p_o);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public static void notifyError(NotificationManager p_oNH, ConfigTree p_oParent, Object p_o, Map p_oCtx, Exception p_e) {
        ByteArrayOutputStream oBO = new ByteArrayOutputStream();
        PrintStream oPS = new PrintStream(oBO);
        try {
            oPS.println(p_o.toString());
            if (null != p_e) {
                p_e.printStackTrace(oPS);
            }
            oPS.close();
            String sMsg = oBO.toString();
            ConfigTree[] oaP = p_oParent.getChildren("NotificationList");
            p_oNH.sendNotifications((Serializable)((Object)sMsg));
            for (int i1 = 0; i1 < oaP.length; ++i1) {
                NotificationList oCurr = new NotificationList(oaP[i1]);
                if (!oCurr.isErr()) continue;
                MacroExpander.replaceMacros(oaP[i1], p_oCtx);
                p_oNH.sendNotifications(oaP[i1], (Serializable)((Object)sMsg));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public static String createExceptionErrorString(String msg, Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(msg);
        sb.append(", Stacktrace : ");
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        sb.append(sw.toString());
        sb.append("]");
        return sb.toString();
    }
}

