/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security.auth.ws;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collections;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.identity.federation.core.wstrust.SamlCredential;
import org.jboss.soa.esb.lifecycle.LifecycleResourceException;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequestImpl;
import org.jboss.soa.esb.services.security.auth.SecurityInfoExtractor;
import org.jboss.soa.esb.smooks.resource.SmooksResource;
import org.jboss.soa.esb.util.ClassUtil;
import org.milyn.Smooks;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.DOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamlAssertionExtractor
implements SecurityInfoExtractor<String> {
    private static final String SMOOK_CONFIG_FILE = "smooks-saml.xml";
    private Smooks smooks;

    public SamlAssertionExtractor() {
        this.createSmooks(SMOOK_CONFIG_FILE);
    }

    public SamlAssertionExtractor(String configFile) {
        this.createSmooks(configFile);
    }

    public Node extractSamlAssertion(String soap) throws IOException {
        if (soap == null || !soap.startsWith("<")) {
            return null;
        }
        ExecutionContext execContext = this.smooks.createExecutionContext();
        this.smooks.filterSource(execContext, (Source)new StreamSource(new StringReader(soap)), new Result[0]);
        DOMModel nodeModel = DOMModel.getModel((ExecutionContext)execContext);
        return (Node)nodeModel.getModels().get("Assertion");
    }

    @Override
    public AuthenticationRequest extractSecurityInfo(String soap) {
        Node samlToken;
        if (soap == null || !soap.startsWith("<")) {
            return null;
        }
        try {
            samlToken = this.extractSamlAssertion(soap);
        }
        catch (IOException e) {
            throw new SecurityException("Could not extract saml token info from :" + soap, e);
        }
        if (samlToken != null) {
            Set<SamlCredential> credential = Collections.singleton(new SamlCredential((Element)samlToken));
            return new AuthenticationRequestImpl.Builder(null, credential).build();
        }
        return null;
    }

    private void createSmooks(String configFile) {
        InputStream is = ClassUtil.getResourceAsStream(configFile, this.getClass());
        if (is == null) {
            throw new IllegalArgumentException("Failed to located configuration file resource: " + configFile);
        }
        try {
            this.smooks = SmooksResource.createSmooksResource(is);
        }
        catch (LifecycleResourceException lre) {
            throw new IllegalStateException("Could not parse " + configFile, lre);
        }
        catch (SAXException e) {
            throw new IllegalStateException("Could not parse " + configFile, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not parse " + configFile, e);
        }
    }
}

