/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.util;

import java.io.IOException;
import javax.jms.JMSException;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.services.security.PasswordUtil;

public class JmsUtil {
    private static Logger log = Logger.getLogger(JmsUtil.class);

    private JmsUtil() {
    }

    public static String getPasswordFromFile(String password) throws JMSException {
        if (PasswordUtil.isPasswordFile(password)) {
            try {
                return new PasswordUtil(password).getPasswordAsString();
            }
            catch (IOException e) {
                String errorMsg = "Could not read password from file : " + password;
                log.error((Object)errorMsg, (Throwable)e);
                throw new JMSException(errorMsg + ", " + e.getMessage());
            }
        }
        return password;
    }

    public static boolean isSecurityConfigured(String principal, String credential) {
        return principal != null && credential != null;
    }
}

