/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.webservices;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;

public class PortComponentMetaData {
    public static final String PARAMETER_WEBSERVICE_ID = "webserviceID";
    private static final Logger log = Logger.getLogger(PortComponentMetaData.class);
    private WebserviceDescriptionMetaData webserviceDescription;
    private String portComponentName;
    private QName wsdlPort;
    private String serviceEndpointInterface;
    private String ejbLink;
    private String servletLink;
    private List<UnifiedHandlerMetaData> handlers = new ArrayList<UnifiedHandlerMetaData>();
    private String contextRoot;
    private Boolean secureWSDLAccess;
    private boolean enableMtom;
    private QName wsdlService;
    private String protocolBinding;
    private UnifiedHandlerChainsMetaData handlerChains;

    public PortComponentMetaData(WebserviceDescriptionMetaData webserviceDescriptionMetaData) {
        this.webserviceDescription = webserviceDescriptionMetaData;
    }

    public WebserviceDescriptionMetaData getWebserviceDescription() {
        return this.webserviceDescription;
    }

    public String getPortComponentName() {
        return this.portComponentName;
    }

    public void setPortComponentName(String string) {
        this.portComponentName = string;
    }

    public QName getWsdlPort() {
        return this.wsdlPort;
    }

    public void setWsdlPort(QName qName) {
        if (qName.getNamespaceURI().length() == 0) {
            log.warn((Object)("<wsdl-port> element in webservices.xml not namespace qualified: " + qName));
        }
        this.wsdlPort = qName;
    }

    public String getEjbLink() {
        return this.ejbLink;
    }

    public void setEjbLink(String string) {
        this.ejbLink = string;
    }

    public String getServletLink() {
        return this.servletLink;
    }

    public void setServletLink(String string) {
        this.servletLink = string;
    }

    public String getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    public void setServiceEndpointInterface(String string) {
        this.serviceEndpointInterface = string;
    }

    public void addHandler(UnifiedHandlerMetaData unifiedHandlerMetaData) {
        this.handlers.add(unifiedHandlerMetaData);
    }

    public UnifiedHandlerMetaData[] getHandlers() {
        UnifiedHandlerMetaData[] unifiedHandlerMetaDataArray = new UnifiedHandlerMetaData[this.handlers.size()];
        this.handlers.toArray(unifiedHandlerMetaDataArray);
        return unifiedHandlerMetaDataArray;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String string) {
        this.contextRoot = string;
    }

    public Boolean getSecureWSDLAccess() {
        return this.secureWSDLAccess;
    }

    public void setSecureWSDLAccess(Boolean bl) {
        this.secureWSDLAccess = bl;
    }

    public boolean isEnableMtom() {
        return this.enableMtom;
    }

    public void setEnableMtom(boolean bl) {
        this.enableMtom = bl;
    }

    public QName getWsdlService() {
        return this.wsdlService;
    }

    public void setWsdlService(QName qName) {
        this.wsdlService = qName;
    }

    public String getProtocolBinding() {
        return this.protocolBinding;
    }

    public void setProtocolBinding(String string) {
        this.protocolBinding = string;
    }

    public UnifiedHandlerChainsMetaData getHandlerChains() {
        return this.handlerChains;
    }

    public void setHandlerChains(UnifiedHandlerChainsMetaData unifiedHandlerChainsMetaData) {
        this.handlerChains = unifiedHandlerChainsMetaData;
    }

    public String serialize() {
        StringBuilder stringBuilder = new StringBuilder("<port-component>");
        stringBuilder.append("<port-component-name>").append(this.portComponentName).append("</port-component-name>");
        stringBuilder.append("<wsdl-port xmlns:").append(this.wsdlPort.getPrefix()).append("='").append(this.wsdlPort.getNamespaceURI()).append("'>");
        stringBuilder.append(this.wsdlPort.getPrefix()).append(':').append(this.wsdlPort.getLocalPart()).append("</wsdl-port>");
        stringBuilder.append("<service-endpoint-interface>").append(this.serviceEndpointInterface).append("</service-endpoint-interface>");
        stringBuilder.append("<service-impl-bean>");
        if (this.ejbLink != null) {
            stringBuilder.append("<ejb-link>" + this.ejbLink + "</ejb-link>");
        } else {
            stringBuilder.append("<servlet-link>" + this.servletLink + "</servlet-link>");
        }
        stringBuilder.append("</service-impl-bean>");
        stringBuilder.append("</port-component>");
        return stringBuilder.toString();
    }
}

