/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public abstract class ServiceLoader {
    public static Object loadService(String string, String string2) {
        Object object = ServiceLoader.loadFromServices(string, null);
        if (object == null) {
            object = ServiceLoader.loadFromPropertiesFile(string, null);
        }
        if (object == null) {
            object = ServiceLoader.loadFromSystemProperty(string, string2);
        }
        return object;
    }

    public static Object loadFromServices(String string, String string2) {
        String string3;
        Object object = null;
        String string4 = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string3 = "META-INF/services/" + string);
        if (inputStream != null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                string4 = bufferedReader.readLine();
                bufferedReader.close();
                if (string4 != null) {
                    Class<?> clazz = classLoader.loadClass(string4);
                    object = clazz.newInstance();
                }
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to load " + string + ": " + string4, throwable);
            }
        }
        if (object == null && string2 != null) {
            object = ServiceLoader.loadDefault(string2);
        }
        return object;
    }

    public static Object loadFromSystemProperty(String string, String string2) {
        Object object = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        PropertyAccessAction propertyAccessAction = new PropertyAccessAction(string);
        String string3 = (String)AccessController.doPrivileged(propertyAccessAction);
        if (string3 != null) {
            try {
                Class<?> clazz = classLoader.loadClass(string3);
                object = clazz.newInstance();
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to load " + string + ": " + string3, throwable);
            }
        }
        if (object == null && string2 != null) {
            object = ServiceLoader.loadDefault(string2);
        }
        return object;
    }

    public static Object loadFromPropertiesFile(String string, String string2) {
        Object object = null;
        String string3 = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        PrivilegedAction privilegedAction = new PropertyAccessAction("java.home");
        String string4 = (String)AccessController.doPrivileged(privilegedAction);
        File file = new File(string4 + "/lib/jaxws.properties");
        if (file.exists()) {
            try {
                privilegedAction = new PropertyFileAccessAction(file.getCanonicalPath());
                Properties properties = (Properties)AccessController.doPrivileged(privilegedAction);
                string3 = properties.getProperty(string);
                if (string3 != null) {
                    Class<?> clazz = classLoader.loadClass(string3);
                    object = clazz.newInstance();
                }
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to load " + string + ": " + string3, throwable);
            }
        }
        if (object == null && string2 != null) {
            object = ServiceLoader.loadDefault(string2);
        }
        return object;
    }

    private static Object loadDefault(String string) {
        Object var1_1 = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (string != null) {
            try {
                Class<?> clazz = classLoader.loadClass(string);
                var1_1 = clazz.newInstance();
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to load: " + string, throwable);
            }
        }
        return var1_1;
    }

    private static class PropertyFileAccessAction
    implements PrivilegedAction {
        private String filename;

        PropertyFileAccessAction(String string) {
            this.filename = string;
        }

        public Object run() {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.filename);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                return properties;
            }
            catch (IOException iOException) {
                throw new SecurityException("Cannot load properties: " + this.filename, iOException);
            }
        }
    }

    private static class PropertyAccessAction
    implements PrivilegedAction {
        private String name;

        PropertyAccessAction(String string) {
            this.name = string;
        }

        public Object run() {
            return System.getProperty(this.name);
        }
    }
}

