/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.api_v3.Clerk;
import org.apache.juddi.api_v3.ClerkDetail;
import org.apache.juddi.api_v3.Node;
import org.apache.juddi.api_v3.NodeDetail;
import org.apache.juddi.api_v3.SaveClerk;
import org.apache.juddi.api_v3.SaveNode;
import org.apache.juddi.v3.client.config.UDDINode;
import org.apache.juddi.v3.client.transport.TransportException;
import org.apache.log4j.Logger;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.v3_service.DispositionReportFaultMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDDIClerk
implements Serializable {
    private static final long serialVersionUID = -8597375975981358134L;
    private Logger log = Logger.getLogger(this.getClass());
    protected String name;
    protected UDDINode uddiNode;
    protected String publisher;
    protected String password;
    private String authToken;
    private String[] classWithAnnotations;
    private String managerName;
    private Map<String, Properties> services = new HashMap<String, Properties>();

    public UDDIClerk() {
    }

    public UDDIClerk(Clerk clerk) {
        this.name = clerk.getName();
        this.password = clerk.getPassword();
        this.publisher = clerk.getPublisher();
        this.uddiNode = new UDDINode(clerk.getNode());
    }

    public String[] getClassWithAnnotations() {
        return this.classWithAnnotations;
    }

    public void setClassWithAnnotations(String[] classWithAnnotations) {
        this.classWithAnnotations = classWithAnnotations;
    }

    public Map<String, Properties> getServices() {
        return this.services;
    }

    public void setServices(Map<String, Properties> services) {
        this.services = services;
    }

    public String getManagerName() {
        return this.managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    public BusinessService register(BusinessService service, Node node) {
        BusinessService businessService = null;
        this.log.info((Object)("Registering service " + ((Name)service.getName().get(0)).getValue() + " with key " + service.getServiceKey()));
        try {
            String authToken = this.getAuthToken(node.getSecurityUrl());
            SaveService saveService = new SaveService();
            saveService.setAuthInfo(authToken);
            saveService.getBusinessService().add(service);
            ServiceDetail serviceDetail = this.getUDDINode().getTransport().getUDDIPublishService(node.getPublishUrl()).saveService(saveService);
            businessService = (BusinessService)serviceDetail.getBusinessService().get(0);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to register service " + ((Name)service.getName().get(0)).getValue() + " ." + e.getMessage()), (Throwable)e);
        }
        catch (Throwable t) {
            this.log.error((Object)("Unable to register service " + ((Name)service.getName().get(0)).getValue() + " ." + t.getMessage()), t);
        }
        this.log.info((Object)("Registering service " + ((Name)service.getName().get(0)).getValue() + " completed."));
        return businessService;
    }

    public BusinessEntity register(BusinessEntity business, Node node) {
        BusinessEntity businessEntity = null;
        this.log.info((Object)("Registering business " + ((Name)business.getName().get(0)).getValue() + " with key " + business.getBusinessKey()));
        try {
            String authToken = this.getAuthToken(node.getSecurityUrl());
            SaveBusiness saveBusiness = new SaveBusiness();
            saveBusiness.setAuthInfo(authToken);
            saveBusiness.getBusinessEntity().add(business);
            BusinessDetail businessDetail = this.getUDDINode().getTransport().getUDDIPublishService(node.getPublishUrl()).saveBusiness(saveBusiness);
            businessEntity = (BusinessEntity)businessDetail.getBusinessEntity().get(0);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to register business " + ((Name)business.getName().get(0)).getValue() + " ." + e.getMessage()), (Throwable)e);
        }
        catch (Throwable t) {
            this.log.error((Object)("Unable to register business " + ((Name)business.getName().get(0)).getValue() + " ." + t.getMessage()), t);
        }
        this.log.info((Object)("Registering businessEntity " + ((Name)businessEntity.getName().get(0)).getValue() + " completed."));
        return businessEntity;
    }

    public void unRegister(BusinessService service, Node node) {
        this.log.info((Object)("UnRegistering binding for service " + ((Name)service.getName().get(0)).getValue()));
        try {
            String authToken = this.getAuthToken(node.getSecurityUrl());
            DeleteBinding deleteBinding = new DeleteBinding();
            deleteBinding.setAuthInfo(authToken);
            for (BindingTemplate binding : service.getBindingTemplates().getBindingTemplate()) {
                deleteBinding.getBindingKey().add(binding.getBindingKey());
            }
            this.getUDDINode().getTransport().getUDDIPublishService(node.getPublishUrl()).deleteBinding(deleteBinding);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to register service " + ((Name)service.getName().get(0)).getValue() + " ." + e.getMessage()), (Throwable)e);
        }
    }

    public BusinessService findService(String serviceKey, Node node) throws DispositionReportFaultMessage, RemoteException, TransportException, ConfigurationException {
        GetServiceDetail getServiceDetail = new GetServiceDetail();
        getServiceDetail.getServiceKey().add(serviceKey);
        getServiceDetail.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
        ServiceDetail sd = this.getUDDINode().getTransport().getUDDIInquiryService(node.getInquiryUrl()).getServiceDetail(getServiceDetail);
        List businessServiceList = sd.getBusinessService();
        if (businessServiceList.size() == 0) {
            throw new ConfigurationException("Could not find Service with key=" + serviceKey);
        }
        return (BusinessService)businessServiceList.get(0);
    }

    public BindingTemplate findServiceBinding(String bindingKey, Node node) throws DispositionReportFaultMessage, RemoteException, TransportException, ConfigurationException {
        GetBindingDetail getBindingDetail = new GetBindingDetail();
        getBindingDetail.getBindingKey().add(bindingKey);
        getBindingDetail.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
        BindingDetail bd = this.getUDDINode().getTransport().getUDDIInquiryService(node.getInquiryUrl()).getBindingDetail(getBindingDetail);
        List bindingTemplateList = bd.getBindingTemplate();
        if (bindingTemplateList.size() == 0) {
            throw new ConfigurationException("Could not find ServiceBinding with key=" + bindingKey);
        }
        return (BindingTemplate)bindingTemplateList.get(0);
    }

    public BusinessEntity findBusiness(String businessKey, Node node) throws DispositionReportFaultMessage, RemoteException, TransportException, ConfigurationException {
        GetBusinessDetail getBusinessDetail = new GetBusinessDetail();
        getBusinessDetail.getBusinessKey().add(businessKey);
        getBusinessDetail.setAuthInfo(node.getSecurityUrl());
        BusinessDetail bd = this.getUDDINode().getTransport().getUDDIInquiryService(node.getInquiryUrl()).getBusinessDetail(getBusinessDetail);
        if (bd.getBusinessEntity().size() == 0) {
            throw new ConfigurationException("Could not find BusinessEntity with key=" + businessKey);
        }
        return (BusinessEntity)bd.getBusinessEntity().get(0);
    }

    private String getAuthToken(String endpointURL) throws TransportException, DispositionReportFaultMessage, RemoteException {
        if (this.authToken == null) {
            GetAuthToken getAuthToken = new GetAuthToken();
            getAuthToken.setUserID(this.getPublisher());
            getAuthToken.setCred(this.getPassword());
            this.authToken = this.getUDDINode().getTransport().getUDDISecurityService(endpointURL).getAuthToken(getAuthToken).getAuthInfo();
        }
        return this.authToken;
    }

    public NodeDetail saveNode(Node node) {
        NodeDetail nodeDetail = null;
        try {
            this.log.info((Object)("Sending Node " + node.getName() + " info to jUDDI " + this.getUDDINode().getName()));
            SaveNode saveNode = new SaveNode();
            saveNode.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
            saveNode.getNode().add(node);
            nodeDetail = this.getUDDINode().getTransport().getJUDDIApiService(node.getJuddiApiUrl()).saveNode(saveNode);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to save node " + node.getName() + " ." + e.getMessage()), (Throwable)e);
        }
        catch (Throwable t) {
            this.log.error((Object)("Unable to save node " + node.getName() + " ." + t.getMessage()), t);
        }
        return nodeDetail;
    }

    public ClerkDetail saveClerk(UDDIClerk senderClerk) {
        ClerkDetail clerkDetail = null;
        try {
            this.log.info((Object)("Sending Clerk " + senderClerk.getName() + " info to jUDDI " + this.getUDDINode().getName()));
            SaveClerk saveClerk = new SaveClerk();
            saveClerk.setAuthInfo(this.getAuthToken(senderClerk.getUDDINode().getSecurityUrl()));
            saveClerk.getClerk().add(this.getApiClerk());
            clerkDetail = this.getUDDINode().getTransport().getJUDDIApiService(senderClerk.getUDDINode().getJuddiApiUrl()).saveClerk(saveClerk);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to save clerk " + this.getName() + " ." + e.getMessage()), (Throwable)e);
        }
        catch (Throwable t) {
            this.log.error((Object)("Unable to save clerk " + this.getName() + " ." + t.getMessage()), t);
        }
        return clerkDetail;
    }

    public Clerk getApiClerk() {
        Clerk apiClerk = new Clerk();
        apiClerk.setName(this.name);
        apiClerk.setNode(this.uddiNode.getApiNode());
        apiClerk.setPassword(this.password);
        apiClerk.setPublisher(this.publisher);
        return apiClerk;
    }

    public UDDINode getUDDINode() {
        return this.uddiNode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUDDINode(UDDINode uddiNode) {
        this.uddiNode = uddiNode;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

