/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.juddi.v3.client.config.UDDIClerkManager;
import org.apache.log4j.Logger;

public class UDDIClerkServlet
extends HttpServlet {
    private static final long serialVersionUID = -91998529871296125L;
    private Logger logger = Logger.getLogger(UDDIClerkServlet.class);
    UDDIClerkManager manager = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            String clientConfigFile = config.getInitParameter("uddi.client.config");
            if (clientConfigFile == null) {
                clientConfigFile = "META-INF/uddi.xml";
            }
            UDDIClerkManager manager = new UDDIClerkManager(clientConfigFile);
            this.logger.info((Object)("Starting Clerk Manager " + manager.getName() + "..."));
            manager.start();
        }
        catch (Exception e) {
            this.logger.error((Object)("UDDI-client could not be started for manager " + this.manager.getName() + ". " + e.getMessage()), (Throwable)e);
        }
        catch (Throwable t) {
            this.logger.error((Object)("UDDI-client could not be started." + t.getMessage()), t);
        }
    }

    public void destroy() {
        try {
            this.manager.stop();
        }
        catch (Exception e) {
            this.logger.error((Object)("UDDI-Clerk Manager could not be stopped for manager " + this.manager.getName() + ". " + e.getMessage()), (Throwable)e);
        }
        catch (Throwable t) {
            this.logger.error((Object)("UDDI-client could not be stopped." + t.getMessage()), t);
        }
        super.destroy();
    }
}

