/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.util;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.CompatVersion;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.PropertyName;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.LocalContextProvider;
import org.jruby.util.URLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemPropertyCatcher {
    public static LocalContextScope getScope(LocalContextScope defaultScope) {
        LocalContextScope scope = defaultScope;
        String s2 = System.getProperty(PropertyName.LOCALCONTEXT_SCOPE.toString());
        if (s2 == null) {
            return scope;
        }
        if ("singlethread".equalsIgnoreCase(s2)) {
            return LocalContextScope.SINGLETHREAD;
        }
        if ("singleton".equalsIgnoreCase(s2)) {
            return LocalContextScope.SINGLETON;
        }
        if ("threadsafe".equalsIgnoreCase(s2)) {
            return LocalContextScope.THREADSAFE;
        }
        return scope;
    }

    public static LocalVariableBehavior getBehavior(LocalVariableBehavior defaultBehavior) {
        LocalVariableBehavior behavior = defaultBehavior;
        String s2 = System.getProperty(PropertyName.LOCALVARIABLE_BEHAVIOR.toString());
        if (s2 == null) {
            return behavior;
        }
        if ("global".equalsIgnoreCase(s2)) {
            return LocalVariableBehavior.GLOBAL;
        }
        if ("persistent".equalsIgnoreCase(s2)) {
            return LocalVariableBehavior.PERSISTENT;
        }
        if ("transient".equalsIgnoreCase(s2)) {
            return LocalVariableBehavior.TRANSIENT;
        }
        if ("bsf".equalsIgnoreCase(s2)) {
            return LocalVariableBehavior.BSF;
        }
        return behavior;
    }

    public static boolean isLazy(boolean defaultLaziness) {
        boolean lazy = defaultLaziness;
        String s2 = System.getProperty(PropertyName.LAZINESS.toString());
        if (s2 == null) {
            return lazy;
        }
        return Boolean.parseBoolean(s2);
    }

    public static void setClassLoader(ScriptingContainer container) {
        String s2 = System.getProperty(PropertyName.CLASSLOADER.toString());
        if (s2 == null || "container".equals(s2) || "current".equals(s2)) {
            container.setClassLoader(container.getClass().getClassLoader());
            return;
        }
        if ("context".equals(s2)) {
            container.setClassLoader(Thread.currentThread().getContextClassLoader());
            return;
        }
        if ("none".equals(s2)) {
            return;
        }
    }

    public static void setConfiguration(ScriptingContainer container) {
        LocalContextProvider provider = container.getProvider();
        RubyInstanceConfig config = provider.getRubyInstanceConfig();
        String s2 = System.getProperty(PropertyName.COMPILEMODE.toString());
        if (s2 != null) {
            if ("jit".equalsIgnoreCase(s2)) {
                config.setCompileMode(RubyInstanceConfig.CompileMode.JIT);
            } else if ("force".equalsIgnoreCase(s2)) {
                config.setCompileMode(RubyInstanceConfig.CompileMode.FORCE);
            } else {
                config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
            }
        }
        if ((s2 = System.getProperty(PropertyName.COMPATVERSION.toString())) != null && SystemPropertyCatcher.isRuby19(s2)) {
            config.setCompatVersion(CompatVersion.RUBY1_9);
        }
    }

    @Deprecated
    public static void setJRubyHome(ScriptingContainer container) {
        String jrubyhome = SystemPropertyCatcher.findJRubyHome(container);
        if (jrubyhome != null) {
            container.getProvider().getRubyInstanceConfig().setJRubyHome(jrubyhome);
        }
    }

    public static String findJRubyHome(Object instance) {
        String jrubyhome = System.getenv("JRUBY_HOME");
        if (jrubyhome != null) {
            return jrubyhome;
        }
        jrubyhome = System.getProperty("jruby.home");
        if (jrubyhome != null) {
            return jrubyhome;
        }
        jrubyhome = SystemPropertyCatcher.findFromJar(instance);
        if (jrubyhome != null) {
            return jrubyhome;
        }
        return null;
    }

    public static String findFromJar(Object instance) {
        URL resource2 = instance.getClass().getResource("/META-INF/jruby.home");
        if (resource2 == null) {
            return null;
        }
        String location = null;
        if (resource2.getProtocol().equals("jar")) {
            location = URLUtil.getPath(resource2);
            if (!location.startsWith("file:")) {
                location = "classpath:/META-INF/jruby.home";
            }
        } else {
            location = "classpath:/META-INF/jruby.home";
        }
        if (location.endsWith("/")) {
            location = location.substring(0, location.length() - 1);
        }
        return location;
    }

    public static List<String> findLoadPaths() {
        String paths = System.getProperty(PropertyName.CLASSPATH.toString());
        ArrayList<String> loadPaths = new ArrayList<String>();
        if (paths == null) {
            paths = System.getProperty("java.class.path");
        }
        if (paths == null) {
            return loadPaths;
        }
        String[] possiblePaths = paths.split(File.pathSeparator);
        String[] prefixes = new String[]{"file", "url"};
        for (int i2 = 0; i2 < possiblePaths.length; ++i2) {
            int startIndex = i2;
            for (int j = 0; j < prefixes.length; ++j) {
                if (!prefixes[j].equals(possiblePaths[i2]) || i2 >= possiblePaths.length - 1) continue;
                loadPaths.add(possiblePaths[i2] + ":" + possiblePaths[++i2]);
                break;
            }
            if (startIndex != i2) continue;
            loadPaths.add(possiblePaths[i2]);
        }
        return loadPaths;
    }

    public static boolean isRuby19(String name2) {
        String n = name2.toLowerCase();
        Pattern p2 = Pattern.compile("j?ruby1[\\._]?9");
        Matcher m = p2.matcher(n);
        return m.matches();
    }

    public static String getBaseDir() {
        String baseDir = System.getenv("PWD");
        if (baseDir == null || "/".equals(baseDir)) {
            baseDir = System.getProperty("user.dir");
        }
        return baseDir;
    }
}

