/*
 * Decompiled with CFR 0.152.
 */
package org.yecht.ruby;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerable;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;
import org.yecht.Data;
import org.yecht.ImplicitScanner;
import org.yecht.MapPart;
import org.yecht.Node;
import org.yecht.ruby.HashStorageLink;
import org.yecht.ruby.ObjectStorageLink;
import org.yecht.ruby.PossibleLinkNode;
import org.yecht.ruby.StorageLink;
import org.yecht.ruby.YAMLExtra;

public class Resolver {
    public static IRubyObject const_find(IRubyObject self, IRubyObject const_name) {
        RubyModule tclass = self.getRuntime().getObject();
        RubyArray tparts = ((RubyString)const_name).split(self.getRuntime().getCurrentContext(), self.getRuntime().newString("::"));
        for (int i2 = 0; i2 < tparts.getLength(); ++i2) {
            String tpart = tparts.entry(i2).toString();
            try {
                tclass = (RubyModule)tclass.getConstant(tpart);
                continue;
            }
            catch (Exception e) {
                return self.getRuntime().getNil();
            }
        }
        return tclass;
    }

    @JRubyMethod
    public static IRubyObject initialize(IRubyObject self) {
        ((RubyObject)self).fastSetInstanceVariable("@tags", RubyHash.newHash(self.getRuntime()));
        return self;
    }

    @JRubyMethod
    public static IRubyObject add_type(IRubyObject self, IRubyObject taguri, IRubyObject cls) {
        IRubyObject tags = self.callMethod(self.getRuntime().getCurrentContext(), "tags");
        ((RubyHash)tags).fastASet(taguri, cls);
        return self.getRuntime().getNil();
    }

    @JRubyMethod
    public static IRubyObject use_types_at(IRubyObject self, IRubyObject hsh) {
        ((RubyObject)self).fastSetInstanceVariable("@tags", hsh);
        return self.getRuntime().getNil();
    }

    @JRubyMethod
    public static IRubyObject detect_implicit(IRubyObject self, IRubyObject val) {
        return RubyString.newEmptyString(self.getRuntime());
    }

    @JRubyMethod
    public static IRubyObject transfer(IRubyObject self, IRubyObject type2, IRubyObject val) {
        final Ruby runtime2 = self.getRuntime();
        ThreadContext ctx = runtime2.getCurrentContext();
        if (type2.isNil() || type2.convertToString().getByteList().realSize == 0) {
            type2 = self.callMethod(ctx, "detect_implicit", val);
        }
        if (!type2.isNil() && type2.convertToString().getByteList().realSize != 0) {
            IRubyObject target_class;
            RubyString colon = runtime2.newString(":");
            IRubyObject tags = self.callMethod(ctx, "tags");
            IRubyObject subclass = target_class = ((RubyHash)tags).op_aref(ctx, type2);
            IRubyObject obj = runtime2.getNil();
            if (target_class.isNil()) {
                RubyArray subclass_parts = runtime2.newArray();
                RubyArray parts = ((RubyString)type2).split(ctx, colon);
                while (parts.getLength() > 1) {
                    subclass_parts.unshift(parts.pop(ctx));
                    IRubyObject partial = parts.join(ctx, colon);
                    target_class = ((RubyHash)tags).op_aref(ctx, partial);
                    if (target_class.isNil()) {
                        ((RubyString)partial).append(colon);
                        target_class = ((RubyHash)tags).op_aref(ctx, partial);
                    }
                    if (target_class.isNil()) continue;
                    subclass = target_class;
                    if (subclass_parts.getLength() <= 0 || !target_class.respondsTo("yaml_tag_subclasses?") || !target_class.callMethod(ctx, "yaml_tag_subclasses?").isTrue()) break;
                    subclass = subclass_parts.join(ctx, colon);
                    IRubyObject subclass_v = Resolver.const_find(self, subclass = target_class.callMethod(ctx, "yaml_tag_read_class", subclass));
                    if (subclass_v != runtime2.getNil()) {
                        subclass = subclass_v;
                        break;
                    }
                    if (target_class == runtime2.getObject() && subclass_v == runtime2.getNil()) {
                        target_class = runtime2.getModule("YAML").getConstant("Object");
                        type2 = subclass;
                        subclass = target_class;
                        break;
                    }
                    throw runtime2.newTypeError("invalid subclass");
                }
            }
            if (target_class.respondsTo("call")) {
                obj = target_class.callMethod(ctx, "call", new IRubyObject[]{type2, val});
            } else if (target_class.respondsTo("yaml_new")) {
                obj = target_class.callMethod(ctx, "yaml_new", new IRubyObject[]{subclass, type2, val});
            } else if (!target_class.isNil()) {
                obj = subclass == runtime2.getBignum() ? RubyNumeric.str2inum(runtime2, val.convertToString(), 10) : ((RubyClass)subclass).allocate();
                if (obj.respondsTo("yaml_initialize")) {
                    obj.callMethod(ctx, "yaml_initialize", new IRubyObject[]{type2, val});
                } else if (!obj.isNil() && val instanceof RubyHash) {
                    final IRubyObject _obj = obj;
                    final IRubyObject _val = val;
                    RubyEnumerable.callEach(runtime2, ctx, val, new BlockCallback(){

                        public IRubyObject call(ThreadContext _ctx, IRubyObject[] largs, Block blk) {
                            IRubyObject ivname = ((RubyArray)largs[0]).entry(0);
                            String ivn = "@" + ivname.convertToString().toString();
                            IRubyObject valueToSet = ((RubyArray)largs[0]).entry(1);
                            if (valueToSet instanceof PossibleLinkNode) {
                                List<StorageLink> sls = ((PossibleLinkNode)((Object)valueToSet)).getLinks();
                                int j = sls.size();
                                for (int i2 = 0; i2 < j; ++i2) {
                                    StorageLink sl = sls.get(i2);
                                    if (!(sl instanceof HashStorageLink) || ((HashStorageLink)sl).hash != _val) continue;
                                    sls.set(i2, new ObjectStorageLink(_obj, ivn, valueToSet));
                                }
                            }
                            _obj.getInstanceVariables().setInstanceVariable(ivn, valueToSet);
                            return runtime2.getNil();
                        }
                    });
                }
            } else {
                RubyArray parts = ((RubyString)type2).split(ctx, colon);
                IRubyObject scheme = parts.shift(ctx);
                if (scheme.convertToString().toString().equals("x-private")) {
                    IRubyObject name2 = parts.join(ctx, colon);
                    obj = ((RubyModule)runtime2.getModule("YAML").getConstant("Yecht")).getConstant("PrivateType").callMethod(ctx, "new", new IRubyObject[]{name2, val});
                } else {
                    IRubyObject domain = parts.shift(ctx);
                    IRubyObject name3 = parts.join(ctx, colon);
                    obj = ((RubyModule)runtime2.getModule("YAML").getConstant("Yecht")).getConstant("DomainType").callMethod(ctx, "new", new IRubyObject[]{domain, name3, val});
                }
            }
            val = obj;
        }
        return val;
    }

    @JRubyMethod
    public static IRubyObject node_import(IRubyObject self, IRubyObject node) {
        final Ruby runtime2 = self.getRuntime();
        ThreadContext ctx = runtime2.getCurrentContext();
        Node n = (Node)node.dataGetStructChecked();
        YAMLExtra x = ((org.yecht.ruby.Node)node).x;
        IRubyObject obj = null;
        switch (n.kind) {
            case Str: {
                Data.Str dd = (Data.Str)n.data;
                obj = RubyString.newStringShared(runtime2, dd.ptr.buffer, dd.ptr.start, dd.len);
                break;
            }
            case Seq: {
                Data.Seq ds = (Data.Seq)n.data;
                obj = RubyArray.newArray(runtime2, ds.idx);
                for (int i2 = 0; i2 < ds.idx; ++i2) {
                    IRubyObject obj2 = (IRubyObject)n.seqRead(i2);
                    ((RubyArray)obj).store(i2, obj2);
                }
                break;
            }
            case Map: {
                Data.Map dm = (Data.Map)n.data;
                obj = RubyHash.newHash(runtime2);
                RubyClass cMergeKey = x.MergeKey;
                RubyClass cDefaultKey = x.DefaultKey;
                RubyClass cHash = runtime2.getHash();
                RubyClass cArray = runtime2.getArray();
                for (int i3 = 0; i3 < dm.idx; ++i3) {
                    IRubyObject k = (IRubyObject)n.mapRead(MapPart.Key, i3);
                    IRubyObject v = (IRubyObject)n.mapRead(MapPart.Value, i3);
                    if (null == v) {
                        v = runtime2.getNil();
                    }
                    boolean skip_aset = false;
                    if (cMergeKey.isInstance(k)) {
                        IRubyObject end2;
                        if (cHash.isInstance(v)) {
                            IRubyObject dup2 = v.callMethod(ctx, "dup");
                            dup2.callMethod(ctx, "update", obj);
                            obj = dup2;
                            skip_aset = true;
                        } else if (cArray.isInstance(v) && cHash.isInstance(end2 = ((RubyArray)v).pop(ctx))) {
                            final IRubyObject dup3 = end2.callMethod(ctx, "dup");
                            v = ((RubyArray)v).reverse();
                            ((RubyArray)v).append(obj);
                            RubyEnumerable.callEach(runtime2, ctx, v, new BlockCallback(){

                                public IRubyObject call(ThreadContext _ctx, IRubyObject[] largs, Block blk) {
                                    IRubyObject entry = largs[0];
                                    IRubyObject tmp = null;
                                    tmp = TypeConverter.convertToTypeWithCheck(entry, runtime2.getHash(), "to_hash");
                                    if (!tmp.isNil()) {
                                        dup3.callMethod(_ctx, "update", tmp);
                                    }
                                    return runtime2.getNil();
                                }
                            });
                            obj = dup3;
                            skip_aset = true;
                        }
                    } else if (cDefaultKey.isInstance(k)) {
                        obj.callMethod(ctx, "default=", v);
                        skip_aset = true;
                    }
                    if (skip_aset) continue;
                    ((RubyHash)obj).fastASet(k, v);
                }
                break;
            }
        }
        if (n.type_id != null) {
            obj = self.callMethod(ctx, "transfer", new IRubyObject[]{runtime2.newString(n.type_id), obj});
        }
        return obj;
    }

    @JRubyMethod
    public static IRubyObject tagurize(IRubyObject self, IRubyObject val) {
        IRubyObject tmp = val.checkStringType();
        if (!tmp.isNil()) {
            String taguri = ImplicitScanner.typeIdToUri(tmp.toString());
            val = self.getRuntime().newString(taguri);
        }
        return val;
    }
}

