/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.message;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;

public class MessagePayloadProxy {
    public static final String USE_LEGACY_EXCHANGE_PATTERNS_CONFIG = "use.legacy.message.payload.exchange.patterns";
    public static final String GET_PAYLOAD_LOCATION = "get-payload-location";
    public static final String SET_PAYLOAD_LOCATION = "set-payload-location";
    public static final String MIME_TYPE = "mime-type";
    private static Logger logger = Logger.getLogger(MessagePayloadProxy.class);
    private static boolean USE_LEGACY_EXCHANGE_LOCATIONS;
    private List<String> getPayloadLocations;
    private List<String> setPayloadLocations;
    private NullPayloadHandling nullGetPayloadHandling = NullPayloadHandling.EXCEPTION;
    private NullPayloadHandling nullSetPayloadHandling = NullPayloadHandling.NONE;

    public MessagePayloadProxy(ConfigTree config, String[] legacyGetPayloadLocations, String[] legacySetPayloadLocations) {
        this(config);
        if (USE_LEGACY_EXCHANGE_LOCATIONS) {
            AssertArgument.isNotNullAndNotEmpty((Object[])legacyGetPayloadLocations, (String)"legacyGetPayloadLocations");
            AssertArgument.isNotNullAndNotEmpty((Object[])legacySetPayloadLocations, (String)"legacySetPayloadLocations");
            this.setDataLocations(legacyGetPayloadLocations, legacySetPayloadLocations);
        }
    }

    public MessagePayloadProxy(ConfigTree config) {
        AssertArgument.isNotNull((Object)config, (String)"config");
        this.setDataLocations(new String[]{config.getAttribute(GET_PAYLOAD_LOCATION, "org.jboss.soa.esb.message.defaultEntry")}, new String[]{config.getAttribute(SET_PAYLOAD_LOCATION, "org.jboss.soa.esb.message.defaultEntry")});
    }

    private void setDataLocations(String[] getPayloadLocations, String[] setPayloadLocations) {
        this.getPayloadLocations = Arrays.asList(getPayloadLocations);
        this.setPayloadLocations = Arrays.asList(setPayloadLocations);
    }

    public Object getPayload(Message message) throws MessageDeliverException {
        AssertArgument.isNotNull((Object)message, (String)"message");
        for (String getPayloadLocation : this.getPayloadLocations) {
            Object object = message.getBody().get(getPayloadLocation);
            if (object == null) continue;
            if (USE_LEGACY_EXCHANGE_LOCATIONS && object instanceof byte[] && getPayloadLocation.equals("org.jboss.soa.esb.message.content.bytes")) {
                return this.legacyDecodeBinaryPayload((byte[])object, (String)message.getProperties().getProperty(MIME_TYPE));
            }
            return object;
        }
        if (this.nullGetPayloadHandling != NullPayloadHandling.NONE) {
            if (this.nullGetPayloadHandling == NullPayloadHandling.LOG) {
                logger.info((Object)("Null data found in message location(s): " + this.getPayloadLocations));
            } else if (this.nullGetPayloadHandling == NullPayloadHandling.WARN) {
                logger.warn((Object)("Null data found in message location(s): " + this.getPayloadLocations));
            } else if (this.nullGetPayloadHandling == NullPayloadHandling.EXCEPTION) {
                throw new MessageDeliverException("Null data found in message location(s): " + this.getPayloadLocations);
            }
        }
        return null;
    }

    public void setPayload(Message message, Object payload) throws MessageDeliverException {
        AssertArgument.isNotNull((Object)message, (String)"message");
        if (payload != null) {
            for (String setPayloadLocation : this.setPayloadLocations) {
                if (USE_LEGACY_EXCHANGE_LOCATIONS && setPayloadLocation.equals("org.jboss.soa.esb.message.content.bytes")) {
                    this.legacyEncodeBinaryPayload(payload, message);
                    continue;
                }
                this.setPayload(message, setPayloadLocation, payload);
            }
        } else {
            if (this.nullSetPayloadHandling != NullPayloadHandling.NONE) {
                if (this.nullSetPayloadHandling == NullPayloadHandling.LOG) {
                    logger.info((Object)("Setting null data in message location(s): " + this.setPayloadLocations));
                } else if (this.nullSetPayloadHandling == NullPayloadHandling.WARN) {
                    logger.warn((Object)("Setting null data in message location(s): " + this.setPayloadLocations));
                } else if (this.nullSetPayloadHandling == NullPayloadHandling.EXCEPTION) {
                    throw new MessageDeliverException("Setting null data in message location(s): " + this.setPayloadLocations);
                }
            }
            for (String getPayloadLocation : this.getPayloadLocations) {
                message.getBody().remove(getPayloadLocation);
            }
            for (String setPayloadLocation : this.setPayloadLocations) {
                message.getBody().remove(setPayloadLocation);
            }
        }
    }

    private void setPayload(Message message, String setPayloadLocation, Object payload) {
        message.getBody().add(setPayloadLocation, payload);
        if (logger.isDebugEnabled()) {
            message.getBody().add(setPayloadLocation + "-set-stack", new Exception("setPayload stack trace for '" + setPayloadLocation + "'."));
        }
    }

    private void legacyEncodeBinaryPayload(Object payload, Message message) {
        if (payload instanceof byte[]) {
            this.setPayload(message, "org.jboss.soa.esb.message.content.bytes", payload);
        } else {
            if (payload instanceof String) {
                try {
                    this.setPayload(message, "org.jboss.soa.esb.message.content.bytes", payload.toString().getBytes("UTF-8"));
                    message.getProperties().setProperty(MIME_TYPE, "text/plain");
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException("Unexpected environmental exception.  UTF-8 character encoding not supported.");
                }
            }
            try {
                this.setPayload(message, "org.jboss.soa.esb.message.content.bytes", payload.toString().getBytes("UTF-8"));
                message.getProperties().setProperty(MIME_TYPE, "java/" + payload.getClass().getName());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Unexpected environmental exception.  UTF-8 character encoding not supported.");
            }
        }
    }

    private Object legacyDecodeBinaryPayload(byte[] bytes, String mimeType) {
        if (mimeType != null && mimeType.trim().equals("text/plain")) {
            try {
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Unexpected environmental exception.  UTF-8 character encoding not supported.");
            }
        }
        return bytes;
    }

    public String getGetPayloadLocation() {
        return this.getPayloadLocations.get(0);
    }

    public String getSetPayloadLocation() {
        return this.setPayloadLocations.get(0);
    }

    public NullPayloadHandling getNullGetPayloadHandling() {
        return this.nullGetPayloadHandling;
    }

    public void setNullGetPayloadHandling(NullPayloadHandling nullGetPayloadHandling) {
        this.nullGetPayloadHandling = nullGetPayloadHandling != null ? nullGetPayloadHandling : NullPayloadHandling.EXCEPTION;
    }

    public NullPayloadHandling getNullSetPayloadHandling() {
        return this.nullSetPayloadHandling;
    }

    public void setNullSetPayloadHandling(NullPayloadHandling nullSetPayloadHandling) {
        this.nullSetPayloadHandling = nullSetPayloadHandling != null ? nullSetPayloadHandling : NullPayloadHandling.NONE;
    }

    public static void setUseLegacyPatterns(boolean useLegacyPatterns) {
        USE_LEGACY_EXCHANGE_LOCATIONS = useLegacyPatterns;
        if (USE_LEGACY_EXCHANGE_LOCATIONS) {
            logger.warn((Object)"Using the legacy payload-to-message exchange patterns.  This is not recommended.  Please change to use the default message location, or the 'input-location' and 'output-location' properties.");
        } else {
            logger.info((Object)"Using the non-legacy payload-to-message exchange pattern.  To switch back to the legacy exchange patterns, use the 'core:use.legacy.message.payload.exchange.patterns' property in jbossesb-properties.xml.");
        }
    }

    public static boolean isUsingLegacyPatterns() {
        return USE_LEGACY_EXCHANGE_LOCATIONS;
    }

    static {
        MessagePayloadProxy.setUseLegacyPatterns(ModulePropertyManager.getPropertyManager((String)"core").getProperty(USE_LEGACY_EXCHANGE_PATTERNS_CONFIG, "false").equals("true"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NullPayloadHandling {
        NONE,
        LOG,
        WARN,
        EXCEPTION;

    }
}

