/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.common.jboss.LoaderRepositoryConfigMetaData;
import org.jboss.metadata.common.jboss.LoaderRepositoryMetaData;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.system.deployers.LoaderRepositoryConfigHelper;

public class LoaderRepositoryMetaDataHelper {
    public static ClassLoadingMetaData create(DeploymentUnit unit, LoaderRepositoryMetaData loaderMetaData) throws DeploymentException {
        return LoaderRepositoryMetaDataHelper.create(unit, loaderMetaData, false);
    }

    public static ClassLoadingMetaData create(DeploymentUnit unit, LoaderRepositoryMetaData loaderMetaData, boolean parentDelegation) throws DeploymentException {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        ClassLoadingMetaData clmd = (ClassLoadingMetaData)unit.getAttachment(ClassLoadingMetaData.class);
        if (clmd != null) {
            return clmd;
        }
        clmd = LoaderRepositoryMetaDataHelper.create(unit.getName(), loaderMetaData, parentDelegation);
        if (clmd != null) {
            unit.addAttachment(ClassLoadingMetaData.class, (Object)clmd);
        }
        return clmd;
    }

    public static ClassLoadingMetaData create(String deploymentName, LoaderRepositoryMetaData loaderMetaData) throws DeploymentException {
        return LoaderRepositoryMetaDataHelper.create(deploymentName, loaderMetaData, false);
    }

    public static ClassLoadingMetaData create(String deploymentName, LoaderRepositoryMetaData loaderMetaData, boolean parentDelegation) throws DeploymentException {
        String name;
        if (deploymentName == null) {
            throw new IllegalArgumentException("Null deployment name");
        }
        if (loaderMetaData == null) {
            throw new IllegalArgumentException("Null loader repository metadata");
        }
        LoaderRepositoryFactory.LoaderRepositoryConfig repositoryConfig = new LoaderRepositoryFactory.LoaderRepositoryConfig();
        repositoryConfig.repositoryClassName = loaderMetaData.getLoaderRepositoryClass();
        if (repositoryConfig.repositoryClassName == null || repositoryConfig.repositoryClassName.length() == 0) {
            repositoryConfig.repositoryClassName = "org.jboss.mx.loading.HeirarchicalLoaderRepository3";
        }
        if ((name = loaderMetaData.getName()) != null) {
            try {
                repositoryConfig.repositoryName = new ObjectName(name.trim());
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException("Loader repository name is malformed: " + name, (Throwable)e);
            }
        }
        StringBuilder configData = new StringBuilder();
        Set children = loaderMetaData.getLoaderRepositoryConfig();
        if (children != null) {
            for (LoaderRepositoryConfigMetaData child : children) {
                String parserClassName = child.getConfigParserClass();
                repositoryConfig.configParserClassName = parserClassName == null || parserClassName.length() == 0 ? "org.jboss.mx.loading.HeirarchicalLoaderRepository3ConfigParser" : parserClassName;
                String childConfig = child.getConfig();
                if (childConfig == null) continue;
                configData.append(childConfig);
            }
        }
        repositoryConfig.repositoryConfig = configData.toString().trim();
        return LoaderRepositoryConfigHelper.create((String)name, (LoaderRepositoryFactory.LoaderRepositoryConfig)repositoryConfig, (boolean)parentDelegation);
    }
}

