/*
 * Copyright 2010 Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.jboss.soa.dsp.example;

import org.jboss.soa.dsp.ServiceEndpointReference;

public class DeployStore {

	private static java.util.Map<String,ServiceEndpointReference> m_serviceEndpointRefs=
					new java.util.HashMap<String,ServiceEndpointReference>();
	
	public static void add(ServiceEndpointReference ser) {
		m_serviceEndpointRefs.put(ser.getDeploymentName(), ser);
	}
	
	public static void remove(ServiceEndpointReference ser) {
		m_serviceEndpointRefs.remove(ser.getDeploymentName());
	}
	
	public static java.util.Set<String> keys() {
		return(m_serviceEndpointRefs.keySet());
	}
	
	public static ServiceEndpointReference get(String key) {
		return(m_serviceEndpointRefs.get(key));
	}
}
