/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.tests;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

import javax.management.MBeanServerConnection;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/**
 * A RiftSaw test helper that deals with test deployment/undeployment, etc.
 * Based on JBossWS equivalent class by Thomas Diesler and Richard Opalka.
 *
 */
public class RiftSawTestHelper {
   private static final String SYSPROP_TEST_ARCHIVE_DIRECTORY = "test.dir";

   private static MBeanServerConnection server;
   private static String testArchiveDir;

   /** Deploy the given archive
    */
   public void deploy(String testName, String archive) throws Exception {
	   URL archiveURL = getTestFile(testName, archive).toURL();
	   getDeployer().deploy(archiveURL);
   }

   /** Undeploy the given archive
    */
   public void undeploy(String testName, String archive) throws Exception {
       URL archiveURL = getTestFile(testName, archive).toURL();
       getDeployer().undeploy(archiveURL);
   }

   public void undeploy(String testName, URL archiveURL) throws Exception {
       getDeployer().undeploy(archiveURL);
   }

   @SuppressWarnings("unchecked")
   public static MBeanServerConnection getServer() {
      if (server == null)
      {
         Hashtable jndiEnv = null;
         try
         {
            InitialContext iniCtx = new InitialContext();
            jndiEnv = iniCtx.getEnvironment();
            server = (MBeanServerConnection)iniCtx.lookup("jmx/invoker/RMIAdaptor");
         }
         catch (NamingException ex)
         {
            throw new RuntimeException("Cannot obtain MBeanServerConnection using jndi props: " + jndiEnv, ex);
         }
      }
      return server;
   }

   private TestDeployer getDeployer() {
      return new TestDeployerJBoss(getServer());
   }

   /** Try to discover the URL for the deployment archive */
   public URL getTestFileURL(String testName, String archive) throws MalformedURLException
   {
      return getTestFile(testName, archive).toURL();
   }

   /** Try to discover the File for the deployment archive */
   public File getTestFile(String testName, String archive) {
      File file = new File(getTestArchiveDir() + java.io.File.separator+
    		  		testName+ java.io.File.separator + archive);
      if (file.exists())
         return file;

      String notSet = (getTestArchiveDir() == null ? " System property '" + SYSPROP_TEST_ARCHIVE_DIRECTORY + "' not set." : "");
      throw new IllegalArgumentException("Cannot obtain '" + file + "'." + notSet);
   }

   public static String getTestArchiveDir() {
      if (testArchiveDir == null)
         testArchiveDir = System.getProperty(SYSPROP_TEST_ARCHIVE_DIRECTORY);

      return testArchiveDir;
   }

}
