/*
 * Copyright 2001-2009 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.juddi.api_v3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for publisherDetail type. Specific to juddi.
 * 
 * @author <a href="mailto:jfaath@apache.org">Jeff Faath</a>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "clientSubscriptionInfoDetail", propOrder = {
    "clientSubscriptionInfo"
})
public class ClientSubscriptionInfoDetail implements Serializable{
	@XmlTransient
	private static final long serialVersionUID = -409328006334478420L;
	protected List<ClientSubscriptionInfo> clientSubscriptionInfo;
   

    /**
     * Gets the value of the ClientSubscriptionInfo property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the ClientSubscriptionInfo property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getClientSubscriptionInfo().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ClientSubscriptionInfo }
     * 
     * 
     */
    public List<ClientSubscriptionInfo> getClientSubscriptionInfo() {
        if (clientSubscriptionInfo == null) {
        	clientSubscriptionInfo = new ArrayList<ClientSubscriptionInfo>();
        }
        return this.clientSubscriptionInfo;
    }

}
