/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.rosetta.pooling;

import java.io.Serializable;

import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

/**
 * Wrapped topic subscriber class.
 */
class WrappedSession implements Session
{
    /**
     * The connection pool associated with the session.
     */
    protected final JmsConnectionPool connectionPool ;
    /**
     * The session.
     */
    private final Session session ;
    /**
     * The session associated with the browser.
     */
    protected JmsSession jmsSession ;

    /**
     * Construct the wrapped topic subscriber.
     * @param connectionPool The connection pool associated with the session.
     * @param jmsSession The JmsSession associated with the subscriber.
     * @param session The session.
     */
    public WrappedSession(final JmsConnectionPool connectionPool, final Session session)
    {
        this.connectionPool = connectionPool ;
        this.session = session ;
    }

    protected void setJmsSession(final JmsSession jmsSession)
    {
        this.jmsSession = jmsSession ;
    }

    public void close()
        throws JMSException
    {
        try
        {
            session.close() ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public void commit()
        throws JMSException
    {
        try
        {
            session.commit() ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public QueueBrowser createBrowser(Queue arg0, String arg1)
    
        throws JMSException
    {
        try
        {
            return session.createBrowser(arg0, arg1) ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public QueueBrowser createBrowser(Queue arg0)
        throws JMSException
    {
        try
        {
            return session.createBrowser(arg0) ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public BytesMessage createBytesMessage()
        throws JMSException
    {
        try
        {
            return session.createBytesMessage() ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public MessageConsumer createConsumer(Destination arg0, String arg1,
            boolean arg2)
        throws JMSException
    {
        try
        {
            return session.createConsumer(arg0, arg1, arg2) ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public MessageConsumer createConsumer(Destination arg0, String arg1)
        throws JMSException
    {
        try
        {
            return session.createConsumer(arg0, arg1) ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public MessageConsumer createConsumer(Destination arg0)
        throws JMSException
    {
        try
        {
            return session.createConsumer(arg0) ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public TopicSubscriber createDurableSubscriber(Topic arg0, String arg1,
            String arg2, boolean arg3)
        throws JMSException
    {
        try
        {
            return session.createDurableSubscriber(arg0, arg1, arg2, arg3) ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public TopicSubscriber createDurableSubscriber(Topic arg0, String arg1)
        throws JMSException
    {
        try
        {
            return session.createDurableSubscriber(arg0, arg1) ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public MapMessage createMapMessage()
        throws JMSException
    {
        try
        {
            return session.createMapMessage() ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public Message createMessage()
        throws JMSException
    {
        try
        {
            return session.createMessage() ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public ObjectMessage createObjectMessage()
        throws JMSException
    {
        try
        {
            return session.createObjectMessage() ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public ObjectMessage createObjectMessage(Serializable arg0)
        throws JMSException
    {
        try
        {
            return session.createObjectMessage(arg0) ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public MessageProducer createProducer(Destination arg0)
        throws JMSException
    {
        try
        {
            return session.createProducer(arg0) ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public Queue createQueue(String arg0)
        throws JMSException
    {
        try
        {
            return session.createQueue(arg0) ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public StreamMessage createStreamMessage()
        throws JMSException
    {
        try
        {
            return session.createStreamMessage() ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public TemporaryQueue createTemporaryQueue()
        throws JMSException
    {
        try
        {
            return session.createTemporaryQueue() ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public TemporaryTopic createTemporaryTopic()
        throws JMSException
    {
        try
        {
            return session.createTemporaryTopic() ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public TextMessage createTextMessage()
        throws JMSException
    {
        try
        {
            return session.createTextMessage() ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public TextMessage createTextMessage(String arg0)
        throws JMSException
    {
        try
        {
            return session.createTextMessage(arg0) ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public Topic createTopic(String arg0)
        throws JMSException
    {
        try
        {
            return session.createTopic(arg0) ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public int getAcknowledgeMode()
        throws JMSException
    {
        try
        {
            return session.getAcknowledgeMode() ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public MessageListener getMessageListener()
        throws JMSException
    {
        try
        {
            return session.getMessageListener() ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public boolean getTransacted()
        throws JMSException
    {
        try
        {
            return session.getTransacted() ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public void recover()
        throws JMSException
    {
        try
        {
            session.recover() ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public void rollback()
        throws JMSException
    {
        try
        {
            session.rollback() ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public void run()
    {
        session.run() ;
    }

    public void setMessageListener(MessageListener arg0)
        throws JMSException
    {
        try
        {
            session.setMessageListener(arg0) ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public void unsubscribe(String arg0)
        throws JMSException
    {
        try
        {
            session.unsubscribe(arg0) ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }
}
