/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.listeners.config.mappers120;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.ListenerTagNames;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.ServiceDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.JcaGatewayDocument.JcaGateway;
import org.jboss.soa.esb.listeners.jca.JcaInflowGateway;
import org.w3c.dom.Element;

/**
 * comment
 *
 * @author <a href="bill@jboss.com">Bill Burke</a>
 * @version $Revision: 36886 $
 */
public class JcaGatewayMapper
{
   public static Element map(Element root, JcaGateway gateway, XMLBeansModel model) throws ConfigurationException
   {
      Element listenerNode = YADOMUtil.addElement(root, "listener");

      listenerNode.setAttribute("name", gateway.getName());

      ServiceDocument.Service service = model.getService(gateway);
      listenerNode.setAttribute(ListenerTagNames.SERVICE_DESCRIPTION_TAG, service.getDescription());
      listenerNode.setAttribute(ListenerTagNames.TARGET_SERVICE_CATEGORY_TAG, service.getCategory());
      listenerNode.setAttribute(ListenerTagNames.TARGET_SERVICE_NAME_TAG, service.getName());

      listenerNode.setAttribute("adapter", gateway.getAdapter());
      listenerNode.setAttribute("endpointClass", gateway.getEndpointClass());
      listenerNode.setAttribute("messagingType", gateway.getMessagingType());
      listenerNode.setAttribute("jcaBridge", gateway.getJcaBridge());
      listenerNode.setAttribute("transacted", Boolean.valueOf(gateway.getTransacted()).toString());

      MapperUtil.mapProperties(gateway.getPropertyList(), listenerNode);
      listenerNode.setAttribute("gatewayClass", JcaInflowGateway.class.getName());
      Element activationConfig = YADOMUtil.addElement(listenerNode, "activation-config");
      MapperUtil.serialize(gateway.getActivationConfig(), activationConfig);


      YADOMUtil.removeEmptyAttributes(listenerNode);
      return listenerNode;
   }
}