/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.internal.soa.esb.couriers.tx;

import junit.framework.TestCase;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.internal.soa.esb.couriers.transport.InVMTransport;

import java.net.URI;

/**
 * Test for https://jira.jboss.org/jira/browse/JBESB-2866.
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class JBESB_2866_UnitTest extends TestCase {

    public void test_passByVal() throws Throwable {
        test(true);
    }

    public void test_passByRef() throws Throwable {
        test(false);
    }

    public void test(boolean passByVal) throws Throwable {
        InVMEpr epr = new InVMEpr(new URI("invm://service"));
        Message message = MessageFactory.getInstance().getMessage();

        epr.setPassByValue(passByVal);
        MockInVMXAResource resource = new MockInVMXAResource(epr, InVMTransport.toDeliveryObject(message, epr.getPassByValue()), InVMXAResource.Operation.REMOVE);

        // In reality, a new XAResource would be created for each retry, but it's the underlying
        // message that matters, so we just need to create 1 instance of MockInVMXAResource and
        // retry the rollback multiple times...
        resource.rollback(null);
        resource.rollback(null);
        resource.rollback(null);
        resource.rollback(null);
        resource.rollback(null);
        assertEquals(5, resource.deliveryCount);
        assertFalse(resource.deliveredToDQL); // not set yet

        // The retry count (default 5) has been hit now.  Nest attempt should result
        // in the message being sent to the DLQ...
        resource.rollback(null);
        assertEquals(5, resource.deliveryCount); // Same as last time
        assertTrue(resource.deliveredToDQL); // set now
    }

    private class MockInVMXAResource extends InVMXAResource {

        private int deliveryCount;
        private boolean deliveredToDQL;

        public MockInVMXAResource(final InVMEpr inVMEpr, final Object msgObject, final Operation op) {
            addEntry(inVMEpr, msgObject, op);
        }

        protected void deliverTx(final InVMEpr inVMEpr, final Object msgObject) throws Exception {
            deliveryCount++;
        }

        protected void deliverToDLQ(Message message) throws MessageDeliverException {
            deliveredToDQL = true;
        }
    }
}
