/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.auth.ws;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;
import static java.util.concurrent.TimeUnit.NANOSECONDS;

import java.io.InputStream;

import junit.framework.JUnit4TestAdapter;

import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.util.ClassUtil;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;


/**
 * Unit test for {@link UsernameTokenExtractor}
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 *
 */
public class BinarySecurityTokenExtractorUnitTest
{
	private BinarySecurityTokenExtractor extractor;
	
	/**
	 * Intentionally ignored. Takes some time to run and is indended to be run maually.
	 */
	@Test
	@Ignore
    public void performance() throws Exception
    {
		final String soap = createKeySoapString("soap-keys-example.xml");
        AuthenticationRequest authRequest = null;
        
        // warm up 
        for (int i = 0; i < 50000; i++)
        {
            authRequest = extractor.extractSecurityInfo(soap);
        }
        
        final int iterations = 1000000;
        final long start = System.nanoTime();
        for (int i = 0; i < iterations; i++)
        {
            authRequest = extractor.extractSecurityInfo(soap);
        }
        final long duration = System.nanoTime() - start;
        System.out.println(iterations + " took : " + NANOSECONDS.toSeconds(duration) + "s");
        
		assertNotNull(authRequest);
		assertTrue( authRequest.getCredentials().size() > 0 );
		Object cert = authRequest.getCredentials().iterator().next();
		assertTrue( cert instanceof java.security.cert.X509Certificate);
    }

	@Test
	public void extractKeySecurityInfo() throws Exception
	{
		final String soap = createKeySoapString("soap-keys-example.xml");
		final AuthenticationRequest authRequest = extractor.extractSecurityInfo(soap);
		assertNotNull(authRequest);
		assertTrue( authRequest.getCredentials().size() > 0 );
		final Object cert = authRequest.getCredentials().iterator().next();
		assertTrue( cert instanceof java.security.cert.X509Certificate);
	}
	
	@Test
	public void extractKeySecurityInfo2() throws Exception
	{
		final String soap = createKeySoapString("soap-keys-example2.xml");
		final AuthenticationRequest authRequest = extractor.extractSecurityInfo(soap);
		assertNotNull(authRequest);
		assertTrue( authRequest.getCredentials().size() > 0 );
		final Object cert = authRequest.getCredentials().iterator().next();
		assertTrue( cert instanceof java.security.cert.X509Certificate);
	}
	
	@Test
	public void extractKeySecurityInfoUsingStringInput() throws Exception
	{
		final String soap = "some payload";
		final AuthenticationRequest authRequest = extractor.extractSecurityInfo(soap);
		assertNull(authRequest);
	}
	
	@Test
	public void extractKeySecurityInfoUsingNullInput() throws Exception
	{
		final String soap = null;
		final AuthenticationRequest authRequest = extractor.extractSecurityInfo(soap);
		assertNull(authRequest);
	}
	
	private String createKeySoapString(final String filename) throws Exception
	{
		return getStringFromFile(filename);
	}
	
	private String getStringFromFile(final String fileName ) throws Exception
	{
		final InputStream inputStream = ClassUtil.getResourceAsStream(fileName, getClass() );
		return new String(StreamUtils.readStream(inputStream));
	}
	
	@Before
	public void createInstance()
	{
		extractor = new BinarySecurityTokenExtractor("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
	}

	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter(BinarySecurityTokenExtractorUnitTest.class);
	}

}
